/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import ucar.nc2.util.IO;
import ucar.nc2.util.net.EasySSLProtocolSocketFactory;

public class HttpClientManager {
    private static boolean debug = false;
    private static HttpClient _client;
    private static int timeout;

    public static HttpClient init(CredentialsProvider provider, String userAgent) {
        HttpClientManager.initHttpClient();
        if (provider != null) {
            _client.getParams().setParameter("http.authentication.credential-provider", (Object)provider);
        }
        if (userAgent != null) {
            _client.getParams().setParameter("http.useragent", (Object)(userAgent + "/NetcdfJava/HttpClient"));
        } else {
            _client.getParams().setParameter("http.useragent", (Object)"NetcdfJava/HttpClient");
        }
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            _client.getHostConfiguration().setProxy(proxyHost, Integer.parseInt(proxyPort));
        }
        return _client;
    }

    public static HttpClient getHttpClient() {
        return _client;
    }

    private static synchronized void initHttpClient() {
        if (_client != null) {
            return;
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        _client = new HttpClient((HttpConnectionManager)connectionManager);
        HttpClientParams params = _client.getParams();
        params.setParameter("http.socket.timeout", (Object)timeout);
        params.setParameter("http.protocol.allow-circular-redirects", (Object)Boolean.TRUE);
        params.setParameter("http.protocol.cookie-policy", (Object)"rfc2109");
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 8443));
    }

    public static void clearState() {
        _client.getState().clearCookies();
        _client.getState().clearCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(String urlString) throws IOException {
        String string;
        GetMethod m = new GetMethod(urlString);
        m.setFollowRedirects(true);
        try {
            _client.executeMethod((HttpMethod)m);
            string = m.getResponseBodyAsString();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            m.releaseConnection();
            throw throwable;
        }
        m.releaseConnection();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int putContent(String urlString, String content) throws IOException {
        int n;
        PutMethod m = new PutMethod(urlString);
        m.setDoAuthentication(true);
        try {
            Header locationHeader;
            m.setRequestEntity((RequestEntity)new StringRequestEntity(content));
            _client.executeMethod((HttpMethod)m);
            int resultCode = m.getStatusCode();
            if (resultCode == 302 && (locationHeader = m.getResponseHeader("location")) != null) {
                String redirectLocation = locationHeader.getValue();
                if (debug) {
                    System.out.println("***Follow Redirection = " + redirectLocation);
                }
                resultCode = HttpClientManager.putContent(redirectLocation, content);
            }
            n = resultCode;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            m.releaseConnection();
            throw throwable;
        }
        m.releaseConnection();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUrlContents(String urlString, int maxKbytes) {
        String string;
        String charset;
        GetMethod m;
        block8: {
            String encoding;
            block7: {
                Header h;
                m = new GetMethod(urlString);
                m.setFollowRedirects(true);
                m.setRequestHeader("Accept-Encoding", "gzip,deflate");
                _client.executeMethod((HttpMethod)m);
                charset = m.getResponseCharSet();
                if (charset == null) {
                    charset = "UTF-8";
                }
                String string2 = encoding = (h = m.getResponseHeader("content-encoding")) == null ? null : h.getValue();
                if (encoding == null || !encoding.equals("deflate")) break block7;
                byte[] body = m.getResponseBody();
                BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(body)), 10000);
                String string3 = HttpClientManager.readContents(is, charset, maxKbytes);
                Object var10_15 = null;
                m.releaseConnection();
                return string3;
            }
            if (encoding == null || !encoding.equals("gzip")) break block8;
            byte[] body = m.getResponseBody();
            BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(body)), 10000);
            String string4 = HttpClientManager.readContents(is, charset, maxKbytes);
            Object var10_16 = null;
            m.releaseConnection();
            return string4;
        }
        try {
            byte[] body = m.getResponseBody(maxKbytes * 1000);
            string = new String(body, charset);
            Object var10_17 = null;
        }
        catch (Exception e) {
            String string5;
            try {
                e.printStackTrace();
                string5 = null;
                Object var10_18 = null;
            }
            catch (Throwable throwable) {
                Object var10_19 = null;
                m.releaseConnection();
                throw throwable;
            }
            m.releaseConnection();
            return string5;
        }
        m.releaseConnection();
        return string;
    }

    private static String readContents(InputStream is, String charset, int maxKbytes) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1000 * maxKbytes);
        IO.copy(is, bout, 1000 * maxKbytes);
        return bout.toString(charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyUrlContentsToFile(String urlString, File file) {
        GetMethod m = new GetMethod(urlString);
        m.setFollowRedirects(true);
        m.setRequestHeader("Accept-Encoding", "gzip,deflate");
        try {
            try {
                Header h;
                String encoding;
                _client.executeMethod((HttpMethod)m);
                String charset = m.getResponseCharSet();
                if (charset == null) {
                    charset = "UTF-8";
                }
                String string = encoding = (h = m.getResponseHeader("content-encoding")) == null ? null : h.getValue();
                if (encoding != null && encoding.equals("deflate")) {
                    BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(m.getResponseBodyAsStream()), 10000);
                    IO.writeToFile(is, file.getPath());
                }
                if (encoding != null && encoding.equals("gzip")) {
                    BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(m.getResponseBodyAsStream()), 10000);
                    IO.writeToFile(is, file.getPath());
                }
                IO.writeToFile(m.getResponseBodyAsStream(), file.getPath());
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var8_10 = null;
                m.releaseConnection();
                return;
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            m.releaseConnection();
            throw throwable;
        }
        m.releaseConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long appendUrlContentsToFile(String urlString, File file, long start, long end) {
        long nbytes = 0L;
        GetMethod m = new GetMethod(urlString);
        m.setRequestHeader("Accept-Encoding", "gzip,deflate");
        m.setFollowRedirects(true);
        m.setRequestHeader("Range", "bytes=" + start + "-" + end);
        try {
            try {
                Header h;
                String encoding;
                _client.executeMethod((HttpMethod)m);
                String charset = m.getResponseCharSet();
                if (charset == null) {
                    charset = "UTF-8";
                }
                String string = encoding = (h = m.getResponseHeader("content-encoding")) == null ? null : h.getValue();
                if (encoding != null && encoding.equals("deflate")) {
                    BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(m.getResponseBodyAsStream()), 10000);
                    nbytes = IO.appendToFile(is, file.getPath());
                }
                if (encoding != null && encoding.equals("gzip")) {
                    BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(m.getResponseBodyAsStream()), 10000);
                    nbytes = IO.appendToFile(is, file.getPath());
                }
                nbytes = IO.appendToFile(m.getResponseBodyAsStream(), file.getPath());
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var14_13 = null;
                m.releaseConnection();
                return nbytes;
            }
            Object var14_12 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            m.releaseConnection();
            throw throwable;
        }
        m.releaseConnection();
        return nbytes;
    }

    static {
        timeout = 0;
    }
}

