/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import java.awt.geom.Point2D;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class RotatedPole
extends ProjectionImpl {
    private static final double RAD_PER_DEG = Math.PI / 180;
    private static final double DEG_PER_RAD = 57.29577951308232;
    private static boolean show = false;
    private ProjectionPointImpl northPole;
    private double[][] rotY = new double[3][3];
    private double[][] rotZ = new double[3][3];

    public RotatedPole() {
        this(0.0, 0.0);
    }

    public RotatedPole(double northPoleLat, double northPoleLon) {
        this.northPole = new ProjectionPointImpl(northPoleLon, northPoleLat);
        this.buildRotationMatrices();
        this.addParameter("grid_mapping_name", "rotated_latitude_longitude");
        this.addParameter("grid_north_pole_latitude", northPoleLat);
        this.addParameter("grid_north_pole_longitude", northPoleLon);
    }

    private void buildRotationMatrices() {
        double betaRad = -(90.0 - this.northPole.y) * (Math.PI / 180);
        double gammaRad = (this.northPole.x + 180.0) * (Math.PI / 180);
        double cosBeta = Math.cos(betaRad);
        double sinBeta = Math.sin(betaRad);
        double cosGamma = Math.cos(gammaRad);
        double sinGamma = Math.sin(gammaRad);
        this.rotY[0][0] = cosBeta;
        this.rotY[0][1] = 0.0;
        this.rotY[0][2] = -sinBeta;
        this.rotY[1][0] = 0.0;
        this.rotY[1][1] = 1.0;
        this.rotY[1][2] = 0.0;
        this.rotY[2][0] = sinBeta;
        this.rotY[2][1] = 0.0;
        this.rotY[2][2] = cosBeta;
        this.rotZ[0][0] = cosGamma;
        this.rotZ[0][1] = sinGamma;
        this.rotZ[0][2] = 0.0;
        this.rotZ[1][0] = -sinGamma;
        this.rotZ[1][1] = cosGamma;
        this.rotZ[1][2] = 0.0;
        this.rotZ[2][0] = 0.0;
        this.rotZ[2][1] = 0.0;
        this.rotZ[2][2] = 1.0;
    }

    public Point2D.Double getNorthPole() {
        return (Point2D.Double)this.northPole.clone();
    }

    public ProjectionImpl constructCopy() {
        return new RotatedPole(this.northPole.getY(), this.northPole.getX());
    }

    public String paramsToString() {
        return " northPole= " + this.northPole;
    }

    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl destPoint) {
        double lat = latlon.getLatitude();
        double lon = latlon.getLongitude();
        double[] p0 = new double[]{Math.cos(lat * (Math.PI / 180)) * Math.cos(lon * (Math.PI / 180)), Math.cos(lat * (Math.PI / 180)) * Math.sin(lon * (Math.PI / 180)), Math.sin(lat * (Math.PI / 180))};
        double[] p1 = new double[]{this.rotZ[0][0] * p0[0] + this.rotZ[0][1] * p0[1] + this.rotZ[0][2] * p0[2], this.rotZ[1][0] * p0[0] + this.rotZ[1][1] * p0[1] + this.rotZ[1][2] * p0[2], this.rotZ[2][0] * p0[0] + this.rotZ[2][1] * p0[1] + this.rotZ[2][2] * p0[2]};
        double[] p2 = new double[]{this.rotY[0][0] * p1[0] + this.rotY[0][1] * p1[1] + this.rotY[0][2] * p1[2], this.rotY[1][0] * p1[0] + this.rotY[1][1] * p1[1] + this.rotY[1][2] * p1[2], this.rotY[2][0] * p1[0] + this.rotY[2][1] * p1[1] + this.rotY[2][2] * p1[2]};
        double lonR = LatLonPointImpl.range180(Math.atan2(p2[1], p2[0]) * 57.29577951308232);
        double latR = Math.asin(p2[2]) * 57.29577951308232;
        if (destPoint == null) {
            destPoint = new ProjectionPointImpl(lonR, latR);
        } else {
            destPoint.setLocation(lonR, latR);
        }
        if (show) {
            System.out.println("LatLon= " + latlon + " proj= " + destPoint);
        }
        return destPoint;
    }

    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl destPoint) {
        double lonR = LatLonPointImpl.range180(ppt.getX());
        double latR = ppt.getY();
        double[] p0 = new double[]{Math.cos(latR * (Math.PI / 180)) * Math.cos(lonR * (Math.PI / 180)), Math.cos(latR * (Math.PI / 180)) * Math.sin(lonR * (Math.PI / 180)), Math.sin(latR * (Math.PI / 180))};
        double[] p1 = new double[]{this.rotY[0][0] * p0[0] + this.rotY[1][0] * p0[1] + this.rotY[2][0] * p0[2], this.rotY[0][1] * p0[0] + this.rotY[1][1] * p0[1] + this.rotY[2][1] * p0[2], this.rotY[0][2] * p0[0] + this.rotY[1][2] * p0[1] + this.rotY[2][2] * p0[2]};
        double[] p2 = new double[]{this.rotZ[0][0] * p1[0] + this.rotZ[1][0] * p1[1] + this.rotZ[2][0] * p1[2], this.rotZ[0][1] * p1[0] + this.rotZ[1][1] * p1[1] + this.rotZ[2][1] * p1[2], this.rotZ[0][2] * p1[0] + this.rotZ[1][2] * p1[1] + this.rotZ[2][2] * p1[2]};
        double lon = Math.atan2(p2[1], p2[0]) * 57.29577951308232;
        double lat = Math.asin(p2[2]) * 57.29577951308232;
        if (destPoint == null) {
            destPoint = new LatLonPointImpl(lat, lon);
        } else {
            destPoint.set(lat, lon);
        }
        if (show) {
            System.out.println("Proj= " + ppt + " latlon= " + destPoint);
        }
        return destPoint;
    }

    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return Math.abs(pt1.getX() - pt2.getX()) > 270.0;
    }

    public boolean equals(Object proj) {
        if (!(proj instanceof RotatedPole)) {
            return false;
        }
        RotatedPole oo = (RotatedPole)proj;
        return this.getNorthPole().equals(oo.getNorthPole());
    }
}

