/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.input;

import com.google.gdata.data.ParseSource;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.gd.Partial;
import com.google.gdata.model.gd.PartialMetadata;
import com.google.gdata.util.ServiceException;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.input.ElementParser;
import com.google.gdata.wireformats.input.InputParser;
import com.google.gdata.wireformats.input.InputProperties;
import com.google.gdata.wireformats.input.InputPropertiesBuilder;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptingPartialParser<T extends Element>
implements InputParser<T> {
    private final InputParser<T> fullParser;

    public static <T extends Element> InputParser<T> from(InputParser<T> parser) {
        return new AdaptingPartialParser<T>(parser);
    }

    private AdaptingPartialParser(InputParser<T> parser) {
        this.fullParser = parser;
    }

    @Override
    public AltFormat getAltFormat() {
        return this.fullParser.getAltFormat();
    }

    @Override
    public Class<? extends T> getResultType() {
        return this.fullParser.getResultType();
    }

    @Override
    public <R extends T> R parse(ParseSource parseSource, InputProperties inProps, Class<R> resultClass) throws IOException, ServiceException {
        ElementMetadata<?, ?> metadata = inProps.getRootMetadata();
        InputProperties partialProperties = ((InputPropertiesBuilder)new InputPropertiesBuilder(inProps).setElementMetadata(new PartialMetadata(metadata))).build();
        PartialParser partialParser = new PartialParser(this.fullParser);
        Partial p = partialParser.parse(parseSource, partialProperties, Partial.class);
        return (R)((Element)resultClass.cast(p.getElement(metadata.getKey())));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PartialParser
    extends ElementParser<Partial> {
        public PartialParser(InputParser<? extends Element> parser) {
            super(parser.getAltFormat(), Partial.class);
        }
    }
}

