/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import com.facebook.api.FacebookException;
import com.facebook.api.FacebookMethod;
import com.facebook.api.FacebookSignatureUtil;
import com.facebook.api.PhotoTag;
import com.facebook.api.ProfileField;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.json.JSONException;
import org.json.JSONStringer;
import org.json.JSONWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookRestClient {
    public static final String TARGET_API_VERSION = "1.0";
    public static final String ERROR_TAG = "error_response";
    public static final String FB_SERVER = "api.facebook.com/restserver.php";
    public static final String SERVER_ADDR = "http://api.facebook.com/restserver.php";
    public static final String HTTPS_SERVER_ADDR = "https://api.facebook.com/restserver.php";
    public static URL SERVER_URL = null;
    public static URL HTTPS_SERVER_URL = null;
    private final String _secret;
    private final String _apiKey;
    private final URL _serverUrl;
    private String _sessionKey;
    private boolean _isDesktop = false;
    private String _sessionSecret;
    private int _userId = -1;
    public static int NUM_AUTOAPPENDED_PARAMS;
    private static boolean DEBUG;
    private Boolean _debug = null;
    private File _uploadFile = null;
    protected static final String CRLF = "\r\n";
    protected static final String PREF = "--";
    protected static final int UPLOAD_BUFFER_SIZE = 512;

    static {
        try {
            SERVER_URL = new URL(SERVER_ADDR);
            HTTPS_SERVER_URL = new URL(HTTPS_SERVER_ADDR);
        }
        catch (MalformedURLException e) {
            System.err.println("MalformedURLException: " + e.getMessage());
            System.exit(1);
        }
        NUM_AUTOAPPENDED_PARAMS = 5;
        DEBUG = false;
    }

    public FacebookRestClient(String apiKey, String secret) {
        this(SERVER_URL, apiKey, secret, null);
    }

    public FacebookRestClient(String apiKey, String secret, String sessionKey) {
        this(SERVER_URL, apiKey, secret, sessionKey);
    }

    public FacebookRestClient(String serverAddr, String apiKey, String secret, String sessionKey) throws MalformedURLException {
        this(new URL(serverAddr), apiKey, secret, sessionKey);
    }

    public FacebookRestClient(URL serverUrl, String apiKey, String secret, String sessionKey) {
        this._sessionKey = sessionKey;
        this._apiKey = apiKey;
        this._secret = secret;
        this._serverUrl = serverUrl != null ? serverUrl : SERVER_URL;
    }

    public static void setDebugAll(boolean isDebug) {
        DEBUG = isDebug;
    }

    public void setDebug(boolean isDebug) {
        this._debug = isDebug;
    }

    public boolean isDebug() {
        return this._debug == null ? DEBUG : this._debug;
    }

    public boolean isDesktop() {
        return this._isDesktop;
    }

    public void setIsDesktop(boolean isDesktop) {
        this._isDesktop = isDesktop;
    }

    public static void printDom(Node n, String prefix) {
        String outString = prefix;
        outString = n.getNodeType() == 3 ? String.valueOf(outString) + "'" + n.getTextContent().trim() + "'" : String.valueOf(outString) + n.getNodeName();
        System.out.println(outString);
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            FacebookRestClient.printDom(children.item(i), String.valueOf(prefix) + "  ");
            ++i;
        }
    }

    private static CharSequence delimit(Collection iterable) {
        if (iterable == null || iterable.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean notFirst = false;
        for (Object item : iterable) {
            if (notFirst) {
                buffer.append(",");
            } else {
                notFirst = true;
            }
            buffer.append(item.toString());
        }
        return buffer;
    }

    protected static CharSequence delimit(Collection<Map.Entry<String, CharSequence>> entries, CharSequence delimiter, CharSequence equals, boolean doEncode) {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean notFirst = false;
        for (Map.Entry<String, CharSequence> entry : entries) {
            if (notFirst) {
                buffer.append(delimiter);
            } else {
                notFirst = true;
            }
            CharSequence value = entry.getValue();
            buffer.append(entry.getKey()).append(equals).append(doEncode ? FacebookRestClient.encode(value) : value);
        }
        return buffer;
    }

    protected Document callMethod(FacebookMethod method, Pair<String, CharSequence> ... paramPairs) throws FacebookException, IOException {
        return this.callMethod(method, (Collection<Pair<String, CharSequence>>)Arrays.asList(paramPairs));
    }

    protected Document callMethod(FacebookMethod method, Collection<Pair<String, CharSequence>> paramPairs) throws FacebookException, IOException {
        HashMap<String, CharSequence> params = new HashMap<String, CharSequence>(2 * method.numTotalParams());
        params.put("method", method.methodName());
        params.put("api_key", this._apiKey);
        params.put("v", TARGET_API_VERSION);
        if (method.requiresSession()) {
            params.put("call_id", Long.toString(System.currentTimeMillis()));
            params.put("session_key", this._sessionKey);
        }
        for (Pair<String, CharSequence> p : paramPairs) {
            CharSequence oldVal = params.put((String)p.first, (CharSequence)p.second);
            if (oldVal == null) continue;
            System.err.printf("For parameter %s, overwrote old value %s with new value %s.", p.first, oldVal, p.second);
        }
        assert (!params.containsKey("sig"));
        String signature = this.generateSignature(FacebookSignatureUtil.convert(params.entrySet()), method.requiresSession());
        params.put("sig", signature);
        try {
            NodeList errors;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            boolean doHttps = this.isDesktop() && FacebookMethod.AUTH_GET_SESSION.equals(method);
            InputStream data = method.takesFile() ? this.postFileRequest(method.methodName(), params) : this.postRequest(method.methodName(), params, doHttps, true);
            Document doc = builder.parse(data);
            doc.normalizeDocument();
            FacebookRestClient.stripEmptyTextNodes(doc);
            if (this.isDebug()) {
                FacebookRestClient.printDom(doc, String.valueOf(method.methodName()) + "| ");
            }
            if ((errors = doc.getElementsByTagName(ERROR_TAG)).getLength() > 0) {
                int errorCode = Integer.parseInt(errors.item(0).getFirstChild().getFirstChild().getTextContent());
                String message = errors.item(0).getFirstChild().getNextSibling().getTextContent();
                throw new FacebookException(errorCode, message);
            }
            return doc;
        }
        catch (ParserConfigurationException ex) {
            System.err.println("huh?" + ex);
        }
        catch (SAXException ex) {
            throw new IOException("error parsing xml");
        }
        return null;
    }

    private static void stripEmptyTextNodes(Node n) {
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Node c = children.item(i);
            if (!c.hasChildNodes() && c.getNodeType() == 3 && c.getTextContent().trim().length() == 0) {
                n.removeChild(c);
                --i;
                --length;
                children = n.getChildNodes();
            } else {
                FacebookRestClient.stripEmptyTextNodes(c);
            }
            ++i;
        }
    }

    private String generateSignature(List<String> params, boolean requiresSession) {
        String secret = this.isDesktop() && requiresSession ? this._sessionSecret : this._secret;
        return FacebookSignatureUtil.generateSignature(params, secret);
    }

    private static String encode(CharSequence target) {
        String result = target.toString();
        try {
            result = URLEncoder.encode(result, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.printf("Unsuccessful attempt to encode '%s' into UTF8", result);
        }
        return result;
    }

    private InputStream postRequest(CharSequence method, Map<String, CharSequence> params, boolean doHttps, boolean doEncode) throws IOException {
        URL serverUrl;
        String buffer = params == null ? "" : FacebookRestClient.delimit((Collection<Map.Entry<String, CharSequence>>)params.entrySet(), "&", "=", doEncode);
        URL uRL = serverUrl = doHttps ? HTTPS_SERVER_URL : this._serverUrl;
        if (this.isDebug()) {
            System.out.print(method);
            System.out.print(" POST: ");
            System.out.print(serverUrl.toString());
            System.out.print("/");
            System.out.println((Object)buffer);
            System.out.flush();
        }
        HttpURLConnection conn = (HttpURLConnection)serverUrl.openConnection();
        try {
            conn.setRequestMethod("POST");
        }
        catch (ProtocolException ex) {
            System.err.println("huh?" + ex);
        }
        conn.setDoOutput(true);
        conn.connect();
        conn.getOutputStream().write(buffer.toString().getBytes());
        return conn.getInputStream();
    }

    public boolean profile_setFBML(CharSequence fbmlMarkup, Integer userId) throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod(FacebookMethod.PROFILE_SET_FBML, new Pair<String, String>("uid", Integer.toString(userId)), new Pair<String, CharSequence>("markup", fbmlMarkup)));
    }

    public Document profile_getFBML(Integer userId) throws FacebookException, IOException {
        return this.callMethod(FacebookMethod.PROFILE_GET_FBML, new Pair<String, String>("uid", Integer.toString(userId)));
    }

    public boolean fbml_refreshRefUrl(String url) throws FacebookException, IOException {
        return this.fbml_refreshRefUrl(new URL(url));
    }

    public boolean fbml_refreshRefUrl(URL url) throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod(FacebookMethod.FBML_REFRESH_REF_URL, new Pair<String, String>("url", url.toString())));
    }

    public boolean fbml_refreshImgSrc(String imageUrl) throws FacebookException, IOException {
        return this.fbml_refreshImgSrc(new URL(imageUrl));
    }

    public boolean fbml_refreshImgSrc(URL imageUrl) throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod(FacebookMethod.FBML_REFRESH_IMG_SRC, new Pair<String, String>("url", imageUrl.toString())));
    }

    public Document feed_publishActionOfUser(CharSequence title, CharSequence body, Collection<Pair<URL, URL>> images, Integer priority) throws FacebookException, IOException {
        return this.feedHandler(FacebookMethod.FEED_PUBLISH_ACTION_OF_USER, title, body, images, priority);
    }

    public Document feed_publishActionOfUser(CharSequence title, CharSequence body) throws FacebookException, IOException {
        return this.feed_publishActionOfUser(title, body, null, null);
    }

    public Document feed_publishActionOfUser(CharSequence title, CharSequence body, Integer priority) throws FacebookException, IOException {
        return this.feed_publishActionOfUser(title, body, null, priority);
    }

    public Document feed_publishActionOfUser(CharSequence title, CharSequence body, Collection<Pair<URL, URL>> images) throws FacebookException, IOException {
        return this.feed_publishActionOfUser(title, body, images, null);
    }

    public Document feed_publishStoryToUser(CharSequence title, CharSequence body, Collection<Pair<URL, URL>> images, Integer priority) throws FacebookException, IOException {
        return this.feedHandler(FacebookMethod.FEED_PUBLISH_STORY_TO_USER, title, body, images, priority);
    }

    public Document feed_publishStoryToUser(CharSequence title, CharSequence body) throws FacebookException, IOException {
        return this.feed_publishStoryToUser(title, body, null, null);
    }

    public Document feed_publishStoryToUser(CharSequence title, CharSequence body, Integer priority) throws FacebookException, IOException {
        return this.feed_publishStoryToUser(title, body, null, priority);
    }

    public Document feed_publishStoryToUser(CharSequence title, CharSequence body, Collection<Pair<URL, URL>> images) throws FacebookException, IOException {
        return this.feed_publishStoryToUser(title, body, images, null);
    }

    protected Document feedHandler(FacebookMethod feedMethod, CharSequence title, CharSequence body, Collection<Pair<URL, URL>> images, Integer priority) throws FacebookException, IOException {
        assert (images == null || images.size() <= 4);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(feedMethod.numParams());
        params.add(new Pair<String, CharSequence>("title", title));
        if (body != null) {
            params.add(new Pair<String, CharSequence>("body", body));
        }
        if (priority != null) {
            params.add(new Pair<String, String>("priority", priority.toString()));
        }
        if (images != null && !images.isEmpty()) {
            int image_count = 0;
            for (Pair<URL, URL> image : images) {
                ++image_count;
                assert (image.first != null);
                params.add(new Pair<String, String>(String.format("image_%d", image_count), ((URL)image.first).toString()));
                if (image.second == null) continue;
                params.add(new Pair<String, String>(String.format("image_%d_link", image_count), ((URL)image.second).toString()));
            }
        }
        return this.callMethod(feedMethod, params);
    }

    public Document events_get(Integer userId, Collection<Long> eventIds, Long startTime, Long endTime) throws FacebookException, IOException {
        boolean hasEnd;
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.EVENTS_GET.numParams());
        boolean hasUserId = userId != null && userId != 0;
        boolean hasEventIds = eventIds != null && !eventIds.isEmpty();
        boolean hasStart = startTime != null && 0L != startTime;
        boolean bl = hasEnd = endTime != null && 0L != endTime;
        if (hasUserId) {
            params.add(new Pair<String, String>("uid", Integer.toString(userId)));
        }
        if (hasEventIds) {
            params.add(new Pair<String, CharSequence>("eids", FacebookRestClient.delimit(eventIds)));
        }
        if (hasStart) {
            params.add(new Pair<String, String>("start_time", startTime.toString()));
        }
        if (hasEnd) {
            params.add(new Pair<String, String>("end_time", endTime.toString()));
        }
        return this.callMethod(FacebookMethod.EVENTS_GET, params);
    }

    public Document events_getMembers(Number eventId) throws FacebookException, IOException {
        assert (eventId != null);
        return this.callMethod(FacebookMethod.EVENTS_GET_MEMBERS, new Pair<String, String>("eid", eventId.toString()));
    }

    public Document friends_areFriends(int userId1, int userId2) throws FacebookException, IOException {
        return this.callMethod(FacebookMethod.FRIENDS_ARE_FRIENDS, new Pair<String, String>("uids1", Integer.toString(userId1)), new Pair<String, String>("uids2", Integer.toString(userId2)));
    }

    public Document friends_areFriends(Collection<Integer> userIds1, Collection<Integer> userIds2) throws FacebookException, IOException {
        assert (userIds1 != null && userIds2 != null);
        assert (!userIds1.isEmpty() && !userIds2.isEmpty());
        assert (userIds1.size() == userIds2.size());
        return this.callMethod(FacebookMethod.FRIENDS_ARE_FRIENDS, new Pair<String, CharSequence>("uids1", FacebookRestClient.delimit(userIds1)), new Pair<String, CharSequence>("uids2", FacebookRestClient.delimit(userIds2)));
    }

    public Document friends_get() throws FacebookException, IOException {
        return this.callMethod(FacebookMethod.FRIENDS_GET, new Pair[0]);
    }

    public Document friends_getAppUsers() throws FacebookException, IOException {
        return this.callMethod(FacebookMethod.FRIENDS_GET_APP_USERS, new Pair[0]);
    }

    public Document users_getInfo(Collection<Integer> userIds, EnumSet<ProfileField> fields) throws FacebookException, IOException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod(FacebookMethod.USERS_GET_INFO, new Pair<String, CharSequence>("uids", FacebookRestClient.delimit(userIds)), new Pair<String, CharSequence>("fields", FacebookRestClient.delimit(fields)));
    }

    public Document users_getInfo(Collection<Integer> userIds, Set<CharSequence> fields) throws FacebookException, IOException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod(FacebookMethod.USERS_GET_INFO, new Pair<String, CharSequence>("uids", FacebookRestClient.delimit(userIds)), new Pair<String, CharSequence>("fields", FacebookRestClient.delimit(fields)));
    }

    public int users_getLoggedInUser() throws FacebookException, IOException {
        Document d = this.callMethod(FacebookMethod.USERS_GET_LOGGED_IN_USER, new Pair[0]);
        return Integer.parseInt(d.getFirstChild().getTextContent());
    }

    public boolean users_isAppAdded() throws FacebookException, IOException {
        return FacebookRestClient.extractBoolean(this.callMethod(FacebookMethod.USERS_IS_APP_ADDED, new Pair[0]));
    }

    public Document photos_get(Integer subjId, Long albumId, Collection<Long> photoIds) throws FacebookException, IOException {
        boolean hasPhotoIds;
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_GET.numParams());
        boolean hasUserId = subjId != null && subjId != 0;
        boolean hasAlbumId = albumId != null && 0L != albumId;
        boolean bl = hasPhotoIds = photoIds != null && !photoIds.isEmpty();
        assert (hasUserId || hasAlbumId || hasPhotoIds);
        if (hasUserId) {
            params.add(new Pair<String, String>("subj_id", Integer.toString(subjId)));
        }
        if (hasAlbumId) {
            params.add(new Pair<String, String>("aid", Long.toString(albumId)));
        }
        if (hasPhotoIds) {
            params.add(new Pair<String, CharSequence>("pids", FacebookRestClient.delimit(photoIds)));
        }
        return this.callMethod(FacebookMethod.PHOTOS_GET, params);
    }

    public Document photos_get(Long albumId, Collection<Long> photoIds) throws FacebookException, IOException {
        return this.photos_get(null, albumId, photoIds);
    }

    public Document photos_get(Integer subjId, Collection<Long> photoIds) throws FacebookException, IOException {
        return this.photos_get(subjId, null, photoIds);
    }

    public Document photos_get(Integer subjId, Long albumId) throws FacebookException, IOException {
        return this.photos_get(subjId, albumId, null);
    }

    public Document photos_get(Collection<Long> photoIds) throws FacebookException, IOException {
        return this.photos_get(null, null, photoIds);
    }

    public Document photos_get(Long albumId) throws FacebookException, IOException {
        return this.photos_get(null, albumId, null);
    }

    public Document photos_get(Integer subjId) throws FacebookException, IOException {
        return this.photos_get(subjId, null, null);
    }

    public Document photos_getAlbums(Integer userId, Collection<Long> albumIds) throws FacebookException, IOException {
        boolean hasAlbumIds;
        boolean hasUserId = userId != null && userId != 0;
        boolean bl = hasAlbumIds = albumIds != null && !albumIds.isEmpty();
        assert (hasUserId || hasAlbumIds);
        if (hasUserId) {
            return hasAlbumIds ? this.callMethod(FacebookMethod.PHOTOS_GET_ALBUMS, new Pair<String, String>("uid", Integer.toString(userId)), new Pair<String, CharSequence>("aids", FacebookRestClient.delimit(albumIds))) : this.callMethod(FacebookMethod.PHOTOS_GET_ALBUMS, new Pair<String, String>("uid", Integer.toString(userId)));
        }
        return this.callMethod(FacebookMethod.PHOTOS_GET_ALBUMS, new Pair<String, CharSequence>("aids", FacebookRestClient.delimit(albumIds)));
    }

    public Document photos_getAlbums(Integer userId) throws FacebookException, IOException {
        return this.photos_getAlbums(userId, null);
    }

    public Document photos_getAlbums(Collection<Long> albumIds) throws FacebookException, IOException {
        return this.photos_getAlbums(null, albumIds);
    }

    public Document photos_getTags(Collection<Long> photoIds) throws FacebookException, IOException {
        return this.callMethod(FacebookMethod.PHOTOS_GET_TAGS, new Pair<String, CharSequence>("pids", FacebookRestClient.delimit(photoIds)));
    }

    public Document photos_createAlbum(String albumName) throws FacebookException, IOException {
        return this.photos_createAlbum(albumName, null, null);
    }

    public Document photos_createAlbum(String name, String description, String location) throws FacebookException, IOException {
        assert (name != null && !"".equals(name));
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_CREATE_ALBUM.numParams());
        params.add(new Pair<String, String>("name", name));
        if (description != null) {
            params.add(new Pair<String, String>("description", description));
        }
        if (location != null) {
            params.add(new Pair<String, String>("location", location));
        }
        return this.callMethod(FacebookMethod.PHOTOS_CREATE_ALBUM, params);
    }

    public Document photos_addTags(Long photoId, Collection<PhotoTag> tags) throws FacebookException, IOException, JSONException {
        assert (photoId > 0L);
        assert (tags != null && !tags.isEmpty());
        JSONWriter tagsJSON = new JSONStringer().array();
        for (PhotoTag tag : tags) {
            tagsJSON = tag.jsonify(tagsJSON);
        }
        String tagStr = tagsJSON.endArray().toString();
        return this.callMethod(FacebookMethod.PHOTOS_ADD_TAG, new Pair<String, String>("pid", photoId.toString()), new Pair<String, String>("tags", tagStr));
    }

    public boolean photos_addTag(Long photoId, Integer taggedUserId, Double xPct, Double yPct) throws FacebookException, IOException {
        return this.photos_addTag(photoId, xPct, yPct, taggedUserId, null);
    }

    public boolean photos_addTag(Long photoId, CharSequence tagText, Double xPct, Double yPct) throws FacebookException, IOException {
        return this.photos_addTag(photoId, xPct, yPct, null, tagText);
    }

    private boolean photos_addTag(Long photoId, Double xPct, Double yPct, Integer taggedUserId, CharSequence tagText) throws FacebookException, IOException {
        assert (photoId != null && !photoId.equals(0));
        assert (taggedUserId != null || tagText != null);
        assert (xPct != null && xPct >= 0.0 && xPct <= 100.0);
        assert (yPct != null && yPct >= 0.0 && yPct <= 100.0);
        Document d = this.callMethod(FacebookMethod.PHOTOS_ADD_TAG, new Pair<String, String>("pid", photoId.toString()), new Pair<String, String>("tag_uid", taggedUserId.toString()), new Pair<String, String>("x", xPct.toString()), new Pair<String, String>("y", yPct.toString()));
        return FacebookRestClient.extractBoolean(d);
    }

    public Document photos_upload(File photo) throws FacebookException, IOException {
        return this.photos_upload(photo, null, null);
    }

    public Document photos_upload(File photo, String caption) throws FacebookException, IOException {
        return this.photos_upload(photo, caption, null);
    }

    public Document photos_upload(File photo, Long albumId) throws FacebookException, IOException {
        return this.photos_upload(photo, null, albumId);
    }

    public Document photos_upload(File photo, String caption, Long albumId) throws FacebookException, IOException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(FacebookMethod.PHOTOS_UPLOAD.numParams());
        assert (photo.exists() && photo.canRead());
        this._uploadFile = photo;
        if (albumId != null) {
            params.add(new Pair<String, String>("aid", Long.toString(albumId)));
        }
        if (caption != null) {
            params.add(new Pair<String, String>("caption", caption));
        }
        return this.callMethod(FacebookMethod.PHOTOS_UPLOAD, params);
    }

    public Document groups_get(Integer userId, Collection<Long> groupIds) throws FacebookException, IOException {
        boolean hasGroups;
        boolean bl = hasGroups = groupIds != null && !groupIds.isEmpty();
        if (userId != null) {
            return hasGroups ? this.callMethod(FacebookMethod.GROUPS_GET, new Pair<String, String>("uid", userId.toString()), new Pair<String, CharSequence>("gids", FacebookRestClient.delimit(groupIds))) : this.callMethod(FacebookMethod.GROUPS_GET, new Pair<String, String>("uid", userId.toString()));
        }
        return hasGroups ? this.callMethod(FacebookMethod.GROUPS_GET, new Pair<String, CharSequence>("gids", FacebookRestClient.delimit(groupIds))) : this.callMethod(FacebookMethod.GROUPS_GET, new Pair[0]);
    }

    public Document groups_getMembers(Number groupId) throws FacebookException, IOException {
        assert (groupId != null);
        return this.callMethod(FacebookMethod.GROUPS_GET_MEMBERS, new Pair<String, String>("gid", groupId.toString()));
    }

    public Document fql_query(CharSequence query) throws FacebookException, IOException {
        assert (query != null);
        return this.callMethod(FacebookMethod.FQL_QUERY, new Pair<String, CharSequence>("query", query));
    }

    public Document notifications_get() throws FacebookException, IOException {
        return this.callMethod(FacebookMethod.NOTIFICATIONS_GET, new Pair[0]);
    }

    public URL notifications_sendRequest(Collection<Integer> recipientIds, CharSequence type, CharSequence content, URL image, boolean isInvite) throws FacebookException, IOException {
        assert (recipientIds != null && !recipientIds.isEmpty());
        assert (type != null);
        assert (content != null);
        assert (image != null);
        Document d = this.callMethod(FacebookMethod.NOTIFICATIONS_SEND_REQUEST, new Pair<String, CharSequence>("to_ids", FacebookRestClient.delimit(recipientIds)), new Pair<String, CharSequence>("type", type), new Pair<String, CharSequence>("content", content), new Pair<String, String>("image", image.toString()), new Pair<String, String>("invite", isInvite ? "1" : "0"));
        String url = d.getFirstChild().getTextContent();
        return url == null || "".equals(url) ? null : new URL(url);
    }

    public URL notifications_send(Collection<Integer> recipientIds, CharSequence notification, CharSequence email) throws FacebookException, IOException {
        Document d;
        String url;
        assert (recipientIds != null && !recipientIds.isEmpty());
        assert (notification != null);
        ArrayList<Pair<String, CharSequence>> args = new ArrayList<Pair<String, CharSequence>>(3);
        args.add(new Pair<String, CharSequence>("to_ids", FacebookRestClient.delimit(recipientIds)));
        args.add(new Pair<String, CharSequence>("notification", email));
        if (email != null) {
            args.add(new Pair<String, CharSequence>("email", email));
        }
        return (url = (d = this.callMethod(FacebookMethod.NOTIFICATIONS_SEND, args)).getFirstChild().getTextContent()) == null || "".equals(url) ? null : new URL(url);
    }

    protected static boolean extractBoolean(Document doc) {
        String content = doc.getFirstChild().getTextContent();
        return 1 == Integer.parseInt(content);
    }

    public InputStream postFileRequest(String methodName, Map<String, CharSequence> params) throws IOException {
        assert (this._uploadFile != null);
        try {
            int i;
            BufferedInputStream bufin = new BufferedInputStream(new FileInputStream(this._uploadFile));
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            URLConnection con = SERVER_URL.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            con.setRequestProperty("MIME-version", TARGET_API_VERSION);
            DataOutputStream out = new DataOutputStream(con.getOutputStream());
            for (Map.Entry<String, CharSequence> entry : params.entrySet()) {
                out.writeBytes(PREF + boundary + CRLF);
                out.writeBytes("Content-disposition: form-data; name=\"" + entry.getKey() + "\"");
                out.writeBytes("\r\n\r\n");
                out.writeBytes(entry.getValue().toString());
                out.writeBytes(CRLF);
            }
            out.writeBytes(PREF + boundary + CRLF);
            out.writeBytes("Content-disposition: form-data; filename=\"" + this._uploadFile.getName() + "\"" + CRLF);
            out.writeBytes("Content-Type: image/jpeg\r\n");
            out.writeBytes(CRLF);
            byte[] b = new byte[512];
            int byteCounter = 0;
            while (-1 != (i = bufin.read(b))) {
                byteCounter += i;
                out.write(b, 0, i);
            }
            out.writeBytes("\r\n--" + boundary + PREF + CRLF);
            out.flush();
            out.close();
            InputStream is = con.getInputStream();
            return is;
        }
        catch (Exception e) {
            System.out.println("exception: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public String auth_createToken() throws FacebookException, IOException {
        Document d = this.callMethod(FacebookMethod.AUTH_CREATE_TOKEN, new Pair[0]);
        return d.getFirstChild().getTextContent();
    }

    public String auth_getSession(String authToken) throws FacebookException, IOException {
        if (this._sessionKey != null) {
            return this._sessionKey;
        }
        Document d = this.callMethod(FacebookMethod.AUTH_GET_SESSION, new Pair<String, String>("auth_token", authToken.toString()));
        this._sessionKey = d.getElementsByTagName("session_key").item(0).getFirstChild().getTextContent();
        this._userId = Integer.parseInt(d.getElementsByTagName("uid").item(0).getFirstChild().getTextContent());
        if (this._isDesktop) {
            this._sessionSecret = d.getElementsByTagName("secret").item(0).getFirstChild().getTextContent();
        }
        return this._sessionKey;
    }

    public int auth_getUserId(String authToken) throws FacebookException, IOException {
        if (this._sessionKey == null) {
            this.auth_getSession(authToken);
        }
        return this._userId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Pair<N, V> {
        public N first;
        public V second;

        public Pair(N name, V value) {
            this.first = name;
            this.second = value;
        }
    }
}

