/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import com.facebook.api.FacebookParam;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacebookSignatureUtil {
    private FacebookSignatureUtil() {
    }

    public static Map<String, CharSequence> extractFacebookParamsFromArray(Map<CharSequence, CharSequence[]> reqParams) {
        if (reqParams == null) {
            return null;
        }
        HashMap<String, CharSequence> result = new HashMap<String, CharSequence>(reqParams.size());
        for (Map.Entry<CharSequence, CharSequence[]> entry : reqParams.entrySet()) {
            CharSequence[] value;
            String key = entry.getKey().toString();
            if (!FacebookParam.isInNamespace(key) || (value = entry.getValue()).length <= 0) continue;
            result.put(key, value[0]);
        }
        return result;
    }

    public static Map<String, CharSequence> extractFacebookNamespaceParams(Map<CharSequence, CharSequence> reqParams) {
        if (reqParams == null) {
            return null;
        }
        HashMap<String, CharSequence> result = new HashMap<String, CharSequence>(reqParams.size());
        for (Map.Entry<CharSequence, CharSequence> entry : reqParams.entrySet()) {
            String key = entry.getKey().toString();
            if (!FacebookParam.isInNamespace(key)) continue;
            result.put(key, entry.getValue());
        }
        return result;
    }

    public static EnumMap<FacebookParam, CharSequence> extractFacebookParams(Map<CharSequence, CharSequence> reqParams) {
        if (reqParams == null) {
            return null;
        }
        EnumMap<FacebookParam, CharSequence> result = new EnumMap<FacebookParam, CharSequence>(FacebookParam.class);
        for (Map.Entry<CharSequence, CharSequence> entry : reqParams.entrySet()) {
            FacebookParam matchingFacebookParam = FacebookParam.get(entry.getKey().toString());
            if (matchingFacebookParam == null) continue;
            result.put(matchingFacebookParam, entry.getValue());
        }
        return result;
    }

    public static boolean verifySignature(EnumMap<FacebookParam, CharSequence> params, String secret) {
        if (params == null || params.isEmpty()) {
            return false;
        }
        CharSequence sigParam = params.remove(FacebookParam.SIGNATURE);
        return sigParam == null ? false : FacebookSignatureUtil.verifySignature(params, secret, sigParam.toString());
    }

    public static boolean verifySignature(EnumMap<FacebookParam, CharSequence> params, String secret, String expected) {
        assert (secret != null && !"".equals(secret));
        if (params == null || params.isEmpty()) {
            return false;
        }
        if (expected == null || "".equals(expected)) {
            return false;
        }
        params.remove(FacebookParam.SIGNATURE);
        List<String> sigParams = FacebookSignatureUtil.convertFacebookParams((Collection<Map.Entry<FacebookParam, CharSequence>>)params.entrySet());
        return FacebookSignatureUtil.verifySignature(sigParams, secret, expected);
    }

    public static boolean verifySignature(Map<String, CharSequence> params, String secret) {
        if (params == null || params.isEmpty()) {
            return false;
        }
        CharSequence sigParam = params.remove(FacebookParam.SIGNATURE.toString());
        return sigParam == null ? false : FacebookSignatureUtil.verifySignature(params, secret, sigParam.toString());
    }

    public static boolean verifySignature(Map<String, CharSequence> params, String secret, String expected) {
        assert (secret != null && !"".equals(secret));
        if (params == null || params.isEmpty()) {
            return false;
        }
        if (expected == null || "".equals(expected)) {
            return false;
        }
        params.remove(FacebookParam.SIGNATURE.toString());
        List<String> sigParams = FacebookSignatureUtil.convert((Collection<Map.Entry<String, CharSequence>>)params.entrySet());
        return FacebookSignatureUtil.verifySignature(sigParams, secret, expected);
    }

    private static boolean verifySignature(List<String> sigParams, String secret, String expected) {
        if (expected == null || "".equals(expected)) {
            return false;
        }
        String signature = FacebookSignatureUtil.generateSignature(sigParams, secret);
        return expected.equals(signature);
    }

    public static List<String> convert(Collection<Map.Entry<String, CharSequence>> entries) {
        ArrayList<String> result = new ArrayList<String>(entries.size());
        for (Map.Entry<String, CharSequence> entry : entries) {
            result.add(String.valueOf(FacebookParam.stripSignaturePrefix(entry.getKey())) + "=" + entry.getValue());
        }
        return result;
    }

    public static List<String> convertFacebookParams(Collection<Map.Entry<FacebookParam, CharSequence>> entries) {
        ArrayList<String> result = new ArrayList<String>(entries.size());
        for (Map.Entry<FacebookParam, CharSequence> entry : entries) {
            result.add(String.valueOf(entry.getKey().getSignatureName()) + "=" + entry.getValue());
        }
        return result;
    }

    public static String generateSignature(List<String> params, String secret) {
        StringBuffer buffer = new StringBuffer();
        Collections.sort(params);
        for (String param : params) {
            buffer.append(param);
        }
        buffer.append(secret);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuffer result = new StringBuffer();
            byte[] byArray = md.digest(buffer.toString().getBytes());
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                result.append(Integer.toHexString((b & 0xF0) >>> 4));
                result.append(Integer.toHexString(b & 0xF));
                ++n2;
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println("MD5 does not appear to be supported" + ex);
            return "";
        }
    }
}

