/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkContentHandler
extends DefaultHandler {
    private final Map<String, String> links = new HashMap<String, String>();
    private String href = null;
    private final StringBuilder text = new StringBuilder();

    public Map<String, String> getLinks() {
        return this.links;
    }

    protected void addLink(String href, String text) {
        this.links.put(href, text);
    }

    @Override
    public void startElement(String uri, String local, String name, Attributes attributes) {
        if ("http://www.w3.org/1999/xhtml".equals(uri) && "a".equals(local)) {
            this.href = attributes.getValue("", "href");
            this.text.setLength(0);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.href != null) {
            this.text.append(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String local, String name) {
        if ("http://www.w3.org/1999/xhtml".equals(uri) && "a".equals(local) && this.href != null) {
            this.addLink(this.href, this.text.toString());
            this.href = null;
            this.text.setLength(0);
        }
    }
}

