/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp.commands;

import com.icegreen.greenmail.smtp.commands.DataCommand;
import com.icegreen.greenmail.smtp.commands.HeloCommand;
import com.icegreen.greenmail.smtp.commands.MailCommand;
import com.icegreen.greenmail.smtp.commands.NoopCommand;
import com.icegreen.greenmail.smtp.commands.QuitCommand;
import com.icegreen.greenmail.smtp.commands.RcptCommand;
import com.icegreen.greenmail.smtp.commands.RsetCommand;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import com.icegreen.greenmail.smtp.commands.VrfyCommand;
import java.util.HashMap;
import java.util.Map;

public class SmtpCommandRegistry {
    private static Map commands = new HashMap();
    private static Object[][] COMMANDS = new Object[][]{{"HELO", new HeloCommand()}, {"EHLO", new HeloCommand()}, {"NOOP", new NoopCommand()}, {"RSET", new RsetCommand()}, {"QUIT", new QuitCommand()}, {"MAIL", new MailCommand()}, {"RCPT", new RcptCommand()}, {"DATA", new DataCommand()}, {"VRFY", new VrfyCommand()}};

    public void load() throws Exception {
        int i = 0;
        while (i < COMMANDS.length) {
            String name = COMMANDS[i][0].toString();
            if (!commands.containsKey(name)) {
                SmtpCommand command = (SmtpCommand)COMMANDS[i][1];
                this.registerCommand(name, command);
            }
            ++i;
        }
    }

    private void registerCommand(String name, SmtpCommand command) {
        commands.put(name, command);
    }

    public SmtpCommand getCommand(String name) {
        if (commands.size() == 0) {
            try {
                this.load();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (SmtpCommand)commands.get(name);
    }
}

