/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.util.DummySSLSocketFactory;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.ServerSetupTest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Random;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class GreenMailUtil {
    private static int generateCount = 0;
    private static final String generateSet = "abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPRSTUVWXYZ23456789";
    private static final int generateSetSize = "abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPRSTUVWXYZ23456789".length();
    private static GreenMailUtil instance = new GreenMailUtil();

    private GreenMailUtil() {
    }

    public static GreenMailUtil instance() {
        return instance;
    }

    public static void copyStream(InputStream src, OutputStream dest) throws IOException {
        byte[] buffer = new byte[1024];
        int read = 0;
        while ((read = src.read(buffer)) > -1) {
            dest.write(buffer, 0, read);
        }
        dest.flush();
    }

    public static MimeMessage newMimeMessage(InputStream inputStream) {
        try {
            return new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), inputStream);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public static MimeMessage newMimeMessage(String mailString) throws MessagingException {
        try {
            byte[] bytes = mailString.getBytes("UTF-8");
            return GreenMailUtil.newMimeMessage(new ByteArrayInputStream(bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean hasNonTextAttachments(Part m) {
        try {
            Object content = m.getContent();
            if (content instanceof MimeMultipart) {
                MimeMultipart mm = (MimeMultipart)content;
                int i = 0;
                while (i < mm.getCount()) {
                    BodyPart p = mm.getBodyPart(i);
                    if (GreenMailUtil.hasNonTextAttachments((Part)p)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return !m.getContentType().trim().toLowerCase().startsWith("text");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static int getLineCount(String str) {
        BufferedReader reader = new BufferedReader(new StringReader(str));
        int ret = 0;
        try {
            while (reader.readLine() != null) {
                ++ret;
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getBody(Part msg) {
        String all = GreenMailUtil.getWholeMessage(msg);
        int i = all.indexOf("\r\n\r\n");
        return all.substring(i + 4, all.length());
    }

    public static String getHeaders(Part msg) {
        String all = GreenMailUtil.getWholeMessage(msg);
        int i = all.indexOf("\r\n\r\n");
        return all.substring(0, i);
    }

    public static String getWholeMessage(Part msg) {
        try {
            ByteArrayOutputStream bodyOut = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)bodyOut);
            return bodyOut.toString("US-ASCII").trim();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getBodyAsBytes(Part msg) {
        return GreenMailUtil.getBody(msg).getBytes();
    }

    public static byte[] getHeaderAsBytes(Part part) {
        return GreenMailUtil.getHeaders(part).getBytes();
    }

    public static String toString(Part msg) {
        return GreenMailUtil.getWholeMessage(msg);
    }

    public static String random() {
        Random r = new Random();
        int nbrOfLetters = r.nextInt(3) + 5;
        return GreenMailUtil.random(nbrOfLetters);
    }

    public static String random(int nbrOfLetters) {
        Random r = new Random();
        StringBuffer ret = new StringBuffer();
        while (nbrOfLetters > 0) {
            int pos = (r.nextInt(generateSetSize) + ++generateCount) % generateSetSize;
            ret.append(generateSet.charAt(pos));
            --nbrOfLetters;
        }
        return ret.toString();
    }

    public static void sendTextEmailTest(String to, String from, String subject, String msg) {
        try {
            GreenMailUtil.sendTextEmail(to, from, subject, msg, ServerSetupTest.SMTP);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendTextEmailSecureTest(String to, String from, String subject, String msg) {
        try {
            GreenMailUtil.sendTextEmail(to, from, subject, msg, ServerSetupTest.SMTPS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getAddressList(Address[] addresses) {
        if (addresses == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < addresses.length) {
            if (i > 0) {
                ret.append(", ");
            }
            ret.append(addresses[i].toString());
            ++i;
        }
        return ret.toString();
    }

    public static void sendTextEmail(String to, String from, String subject, String msg, ServerSetup setup) {
        try {
            Session session = GreenMailUtil.getSession(setup);
            Address[] tos = new Address[]{};
            tos = new InternetAddress[]{new InternetAddress(to)};
            InternetAddress[] froms = new InternetAddress[]{new InternetAddress(from)};
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setSubject(subject);
            mimeMessage.setFrom((Address)froms[0]);
            mimeMessage.setText(msg);
            Transport.send((Message)mimeMessage, (Address[])tos);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Session getSession(ServerSetup setup) {
        Properties props = new Properties();
        props.put("mail.smtps.starttls.enable", Boolean.TRUE);
        if (setup.isSecure()) {
            props.setProperty("mail.smtp.socketFactory.class", DummySSLSocketFactory.class.getName());
        }
        props.setProperty("mail.transport.protocol", setup.getProtocol());
        props.setProperty("mail.smtp.port", String.valueOf(setup.getPort()));
        props.setProperty("mail.smtps.port", String.valueOf(setup.getPort()));
        Session session = Session.getInstance((Properties)props, null);
        return session;
    }

    public static void sendAttachmentEmail(String to, String from, String subject, String msg, final byte[] attachment, final String contentType, final String filename, String description, ServerSetup setup) throws MessagingException, IOException {
        Session session = GreenMailUtil.getSession(setup);
        InternetAddress[] tos = new InternetAddress[]{new InternetAddress(to)};
        InternetAddress[] froms = new InternetAddress[]{new InternetAddress(from)};
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setSubject(subject);
        mimeMessage.setFrom((Address)froms[0]);
        MimeMultipart multiPart = new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        multiPart.addBodyPart((BodyPart)textPart);
        textPart.setText(msg);
        MimeBodyPart binaryPart = new MimeBodyPart();
        multiPart.addBodyPart((BodyPart)binaryPart);
        DataSource ds = new DataSource(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(attachment);
            }

            public OutputStream getOutputStream() throws IOException {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                byteStream.write(attachment);
                return byteStream;
            }

            public String getContentType() {
                return contentType;
            }

            public String getName() {
                return filename;
            }
        };
        binaryPart.setDataHandler(new DataHandler(ds));
        binaryPart.setFileName(filename);
        binaryPart.setDescription(description);
        mimeMessage.setContent((Multipart)multiPart);
        Transport.send((Message)mimeMessage, (Address[])tos);
    }
}

