/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.util.ObjectGUID;

public final class ModelHelper {
    private static Map<String, Set> classMap = new HashMap<String, Set>();
    private static ReadWriteLock cacheLock = new ReentrantReadWriteLock();

    public static boolean isCustomProperty(ModelObject object, String propertyName) {
        return !ModelHelper.isModelProperty(object, propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isModelProperty(ModelObject object, String propertyName) {
        HashSet<String> propertyMap;
        block13: {
            if (object == null || propertyName == null) {
                throw new IllegalArgumentException("ModelObject and PropertyName are mandatory.");
            }
            Class<?> modelClass = object.getClass();
            cacheLock.readLock().lock();
            try {
                propertyMap = classMap.get(modelClass.getName());
            }
            finally {
                cacheLock.readLock().unlock();
            }
            if (propertyMap == null) {
                cacheLock.writeLock().lock();
                try {
                    propertyMap = classMap.get(modelClass.getName());
                    if (propertyMap != null) break block13;
                    propertyMap = new HashSet<String>();
                    classMap.put(modelClass.getName(), propertyMap);
                    try {
                        Class<?> klass = modelClass;
                        do {
                            Field[] fields = klass.getFields();
                            for (int i = 0; i < fields.length; ++i) {
                                if (!fields[i].getName().startsWith("PROP_")) continue;
                                String fieldValue = (String)fields[i].get(object);
                                propertyMap.add(fieldValue);
                            }
                        } while ((klass = klass.getSuperclass()) != null);
                    }
                    catch (IllegalAccessException iae) {
                        throw new PlatformRuntimeException("Unable to inspect properties on model object class: " + modelClass.getName());
                    }
                }
                finally {
                    cacheLock.writeLock().unlock();
                }
            }
        }
        return propertyMap.contains(propertyName);
    }

    public static String newGUID() {
        return new ObjectGUID().toString();
    }

    public static void resetId(ModelObject object, String id) {
        if (object instanceof AbstractModelObject) {
            ((AbstractModelObject)object).setId(id);
        }
    }
}

