/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.springframework.extensions.surf.cache.CacheItem;
import org.springframework.extensions.surf.cache.ContentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCache<K>
implements ContentCache<K> {
    protected final HashMap<String, CacheItem<K>> cache;
    protected final long timeout;

    public BasicCache(long timeout) {
        this(timeout, 256);
    }

    public BasicCache(long timeout, int size) {
        this.timeout = timeout;
        if (size < 1) {
            throw new IllegalArgumentException("Cache size must be +ve value");
        }
        this.cache = new HashMap(size);
    }

    @Override
    public synchronized K get(String key) {
        CacheItem<K> item = this.cache.get(key);
        if (item == null) {
            return null;
        }
        if (item.isExpired()) {
            this.remove(key);
            return null;
        }
        return item.object;
    }

    @Override
    public synchronized void remove(String key) {
        if (key == null) {
            return;
        }
        this.cache.remove(key);
    }

    @Override
    public synchronized void put(String key, K obj) {
        this.put(key, obj, this.timeout);
    }

    @Override
    public synchronized void put(String key, K obj, long timeout) {
        CacheItem<K> item = new CacheItem<K>(key, obj, timeout);
        this.cache.put(key, item);
    }

    @Override
    public synchronized void invalidate() {
        this.cache.clear();
    }

    public Collection<CacheItem<K>> values() {
        return this.cache.values();
    }

    public Set<String> keys() {
        return this.cache.keySet();
    }
}

