/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.cache.CacheItem;
import org.springframework.extensions.surf.cache.ContentCache;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.webscripts.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelObjectCache
implements ContentCache<ModelObject> {
    private static final long TIMEOUT = 86400000L;
    protected final Store store;
    protected final long delay;
    protected final long timeout;
    protected final Map<String, CacheItem<ModelObject>> cache = new ConcurrentHashMap<String, CacheItem<ModelObject>>(256);

    public ModelObjectCache(Store store, long delay) {
        this(store, 86400000L, delay);
    }

    public ModelObjectCache(Store store, long timeout, long delay) {
        this.delay = delay;
        this.store = store;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelObject get(String key) {
        ModelObject obj = null;
        CacheItem<ModelObject> item = this.cache.get(key);
        if (item != null) {
            CacheItem<ModelObject> cacheItem = item;
            synchronized (cacheItem) {
                long now;
                obj = (ModelObject)item.object;
                if (this.delay >= 0L && this.delay < (now = System.currentTimeMillis()) - item.lastChecked) {
                    item.lastChecked = now;
                    if (obj != ModelObjectSentinel.instance) {
                        String path = obj.getStoragePath();
                        try {
                            if (this.store.lastModified(path) > obj.getModificationTime()) {
                                this.remove(key);
                                obj = null;
                            }
                        }
                        catch (IOException ex) {
                            this.remove(key);
                            obj = null;
                        }
                    } else {
                        this.remove(key);
                        obj = null;
                    }
                }
            }
        }
        return obj;
    }

    @Override
    public void invalidate() {
        this.cache.clear();
    }

    @Override
    public void put(String key, ModelObject obj) {
        this.put(key, obj, this.timeout);
    }

    @Override
    public void put(String key, ModelObject obj, long timeout) {
        CacheItem<ModelObject> item = new CacheItem<ModelObject>(key, obj, timeout);
        this.cache.put(key, item);
    }

    @Override
    public void remove(String key) {
        if (key == null) {
            return;
        }
        this.cache.remove(key);
    }

    public Collection<CacheItem<ModelObject>> values() {
        return this.cache.values();
    }

    public Set<String> keys() {
        return this.cache.keySet();
    }

    public static class ModelObjectSentinel
    extends AbstractModelObject {
        private static ModelObjectSentinel instance = new ModelObjectSentinel();

        private ModelObjectSentinel() {
        }

        public static ModelObjectSentinel getInstance() {
            return instance;
        }

        public String getTypeId() {
            return "ModelObjectSentinel";
        }
    }
}

