/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletResponse;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.render.Renderer;

public abstract class AbstractRenderer
implements Renderer {
    private RenderService renderService;

    public void setRenderService(RenderService renderService) {
        this.renderService = renderService;
    }

    public RenderService getRenderService() {
        return this.renderService;
    }

    public void render(RequestContext context, ModelObject object, RenderFocus focus) throws RendererExecutionException {
        context.setValue("currentRenderer", (Serializable)((Object)this.getClass().getName()));
        if (focus == null || focus == RenderFocus.BODY) {
            this.body(context, object);
        } else if (focus == RenderFocus.ALL) {
            this.all(context, object);
        } else if (focus == RenderFocus.HEADER) {
            this.header(context, object);
        }
    }

    public void all(RequestContext context, ModelObject object) throws RendererExecutionException {
        this.header(context, object);
        this.body(context, object);
    }

    public void header(RequestContext context, ModelObject object) throws RendererExecutionException {
        String stamp = "<!-- Generated by " + this.getClass().getName() + " -->";
        if (context != null && object != null) {
            stamp = "<!-- Generated by " + this.getClass().getName() + " for " + object.getId() + " -->";
        }
        stamp = stamp + "\r\n";
        AbstractRenderer.print(context, stamp);
    }

    public abstract void body(RequestContext var1, ModelObject var2) throws RendererExecutionException;

    protected void print(HttpServletResponse response, String str) throws RendererExecutionException {
        try {
            response.getWriter().print(str);
        }
        catch (IOException ex) {
            throw new RendererExecutionException("Unable to print string to response: " + str, ex);
        }
    }

    protected static void print(RequestContext context, String str) throws RendererExecutionException {
        try {
            context.getResponse().getWriter().print(str);
        }
        catch (IOException ex) {
            throw new RendererExecutionException("Unable to output string to response: " + str, ex);
        }
    }
}

