/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render.bean;

import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.render.AbstractRenderer;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.TemplateInstance;

public class TemplateInstanceRenderer
extends AbstractRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateComponentDependencies(RequestContext context, ModelObject object) throws RendererExecutionException {
        TemplateInstance template = (TemplateInstance)object;
        try {
            context.setPassiveMode(true);
            this.getRenderService().processTemplate(context, RenderFocus.BODY, template);
        }
        finally {
            context.setPassiveMode(false);
        }
    }

    public void header(RequestContext context, ModelObject object) throws RendererExecutionException {
        RenderService renderService = this.getRenderService();
        if (object instanceof TemplateInstance) {
            TemplateInstance template = (TemplateInstance)object;
            if (template != null) {
                Component component = null;
                Component[] components = context.getRenderingComponents();
                if (components != null) {
                    for (int i = 0; i < components.length; ++i) {
                        component = components[i];
                        renderService.renderComponent(context, RenderFocus.HEADER, component, null, true);
                        TemplateInstanceRenderer.print(context, "\r\n");
                    }
                }
            }
        } else if (object instanceof Component) {
            renderService.renderComponent(context, RenderFocus.HEADER, (Component)object, null, true);
            TemplateInstanceRenderer.print(context, "\r\n");
        }
        this.postHeaderProcess(context);
    }

    public void body(RequestContext context, ModelObject object) throws RendererExecutionException {
        TemplateInstance template = (TemplateInstance)object;
        this.calculateComponentDependencies(context, object);
        this.getRenderService().processTemplate(context, RenderFocus.BODY, template);
    }

    public void postHeaderProcess(RequestContext context) throws RendererExecutionException {
    }
}

