/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.resource.support;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.resource.AbstractResource;
import org.springframework.extensions.surf.resource.ResourceContent;
import org.springframework.extensions.surf.resource.ResourceContentImpl;
import org.springframework.extensions.surf.resource.ResourceXMLContent;
import org.springframework.extensions.surf.resource.ResourceXMLContentImpl;
import org.springframework.extensions.surf.util.XMLUtil;

public class CMISResource
extends AbstractResource {
    private static Log logger = LogFactory.getLog(CMISResource.class);
    public static Namespace NAMESPACE_APP = Namespace.get((String)"app", (String)"http://www.w3.org/2007/app");
    public static Namespace NAMESPACE_CMISRA = Namespace.get((String)"cmisra", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200901");
    public static Namespace NAMESPACE_CMIS = Namespace.get((String)"cmis", (String)"http://docs.oasis-open.org/ns/cmis/core/200901");
    public static Namespace NAMESPACE_ALF = Namespace.get((String)"alf", (String)"http://www.alfresco.org");
    public static Namespace NAMESPACE_OPENSEARCH = Namespace.get((String)"opensearch", (String)"http://a9.com/-/spec/opensearch/1.1/");
    private String objectTypeId = null;
    protected FrameworkBean frameworkUtil;

    public CMISResource(String protocolId, String endpointId, String objectId, FrameworkBean frameworkUtil) {
        super(protocolId, endpointId, objectId, frameworkUtil);
    }

    public ResourceContent getMetadata() throws IOException {
        return new ResourceXMLContentImpl(this, this.getMetadataURL(), this.frameworkUtil);
    }

    public String getMetadataURL() {
        String metadataURL = "/api";
        if (this.getObjectId() != null) {
            metadataURL = "/api/" + this.getObjectId();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CMIS resource metadata url: " + metadataURL));
        }
        return metadataURL;
    }

    public ResourceContent getContent() throws IOException {
        ResourceContentImpl content = null;
        if (this.getContentURL() != null) {
            content = new ResourceContentImpl(this, this.getContentURL(), this.frameworkUtil);
        }
        return content;
    }

    public String getContentURL() {
        String contentURL = null;
        if (this.getObjectId() != null) {
            contentURL = "/api/" + this.getObjectId() + "/content";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CMIS resource content url: " + contentURL));
        }
        return contentURL;
    }

    public synchronized String getObjectTypeId() {
        if (this.objectTypeId == null) {
            try {
                ResourceXMLContent rc = (ResourceXMLContent)this.getMetadata();
                Element rootElement = rc.getDocument().getRootElement();
                if ("entry".equals(rootElement.getName())) {
                    Element cmisraObject = rootElement.element(QName.get((String)"object", (Namespace)NAMESPACE_CMISRA));
                    Element cmisProperties = cmisraObject.element(QName.get((String)"properties", (Namespace)NAMESPACE_CMIS));
                    List propertyIds = cmisProperties.elements(QName.get((String)"propertyId", (Namespace)NAMESPACE_CMIS));
                    for (int i = 0; i < propertyIds.size(); ++i) {
                        Element propertyId = (Element)propertyIds.get(i);
                        if (!"cmis:baseTypeId".equals(propertyId.attribute("propertyDefinitionId").getValue())) continue;
                        Element valueElement = propertyId.element(QName.get((String)"value", (Namespace)NAMESPACE_CMIS));
                        this.objectTypeId = XMLUtil.getValue(valueElement);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.objectTypeId;
    }

    public boolean isContainer() {
        return false;
    }
}

