/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.uri;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.uri.UriTemplateMappingIndex;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class UriTemplateController
extends AbstractController {
    private static Log logger = LogFactory.getLog(UriTemplateController.class);
    public static final String CONFIG_ELEMENT = "UriTemplate";
    private ConfigService configService;
    private UriTemplateMappingIndex uriTemplateIndex;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void init() {
        this.initUriIndex(this.configService);
    }

    private void initUriIndex(ConfigService configService) {
        Config config = configService.getConfig((Object)CONFIG_ELEMENT);
        if (config == null) {
            throw new PlatformRuntimeException("Cannot find required config element 'UriTemplate'.");
        }
        ConfigElement uriConfig = config.getConfigElement("uri-mappings");
        if (uriConfig == null) {
            throw new PlatformRuntimeException("Missing required config element 'uri-mappings' under 'UriTemplate'.");
        }
        this.uriTemplateIndex = new UriTemplateMappingIndex(uriConfig);
    }

    private String matchUriTemplate(String uri) {
        String resource = this.uriTemplateIndex.findMatchAndReplace(uri);
        if (resource == null) {
            resource = uri;
        }
        return resource;
    }

    public ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String uri = (String)req.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        String qs = req.getQueryString();
        uri = uri + (qs != null ? "?" + qs : "");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Matching application URI template: " + uri));
        }
        String resource = this.matchUriTemplate(uri);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolved uri template to resource: " + resource));
        }
        req.getRequestDispatcher(resource).forward((ServletRequest)req, (ServletResponse)res);
        return null;
    }
}

