/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.webscripts.AbstractStore;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptLoader;
import org.springframework.extensions.webscripts.WebScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceStore
extends AbstractStore {
    private static Log logger = LogFactory.getLog(ResourceStore.class);
    protected PathMatchingResourcePatternResolver resolver = null;
    private Resource rootResource = null;
    private String root;

    protected abstract PathMatchingResourcePatternResolver getResourceResolver();

    protected abstract List<String> matchDocumentPaths(String var1) throws IOException;

    protected boolean isForbidden(String documentPath) {
        return false;
    }

    public void init() {
        this.resolver = this.getResourceResolver();
        if (this.root == null) {
            this.root = "/";
        }
    }

    public void setPath(String root) {
        this.root = root;
    }

    public String getPath() {
        return this.root;
    }

    protected String getRoot() {
        return this.getPath();
    }

    public Resource getRootResource() {
        if (this.rootResource == null) {
            this.rootResource = this.resolver.getResource(this.root);
        }
        return this.rootResource;
    }

    protected String toResourcePath(String documentPath) {
        if (documentPath.startsWith("/")) {
            documentPath = documentPath.substring(1);
        }
        String resourcePath = null;
        resourcePath = "/".equals(this.getRoot()) ? "/" + documentPath : this.getRoot() + "/" + documentPath;
        return resourcePath;
    }

    protected String toDocumentPath(String resourcePath) {
        String documentPath = null;
        if (resourcePath.startsWith(this.getRoot()) && (documentPath = resourcePath.substring(this.getRoot().length())).startsWith("/")) {
            documentPath = documentPath.substring(1);
        }
        return documentPath;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean exists() {
        return this.getRootResource().exists();
    }

    public boolean hasDocument(String documentPath) {
        boolean has = false;
        if (!this.isForbidden(documentPath)) {
            String resourcePath = this.toResourcePath(documentPath);
            Resource resource = this.resolver.getResource(resourcePath);
            has = resource.exists();
        }
        return has;
    }

    public long lastModified(String documentPath) throws IOException {
        long lastModified = -1L;
        if (!this.isForbidden(documentPath)) {
            String resourcePath = this.toResourcePath(documentPath);
            Resource resource = this.resolver.getResource(resourcePath);
            lastModified = resource.lastModified();
        }
        return lastModified;
    }

    public void updateDocument(String documentPath, String content) throws IOException {
        throw new IOException("Cannot update a document in a web application store - the store is read-only");
    }

    public boolean removeDocument(String documentPath) throws IOException {
        throw new IOException("Cannot update a document in a web application store - the store is read-only");
    }

    public void createDocument(String documentPath, String content) throws IOException {
        throw new IOException("Cannot update a document in a web application store - the store is read-only");
    }

    public InputStream getDocument(String documentPath) throws IOException {
        if (this.isForbidden(documentPath)) {
            throw new IOException("Document path: " + documentPath + " is within a protected directory, cannot retrieve input stream");
        }
        String resourcePath = this.toResourcePath(documentPath);
        Resource resource = this.resolver.getResource(resourcePath);
        return resource.getInputStream();
    }

    public String[] getAllDocumentPaths() {
        String[] paths;
        try {
            List<String> documentPaths = this.matchDocumentPaths("/**/*");
            paths = documentPaths.toArray(new String[documentPaths.size()]);
        }
        catch (IOException e) {
            paths = new String[]{};
        }
        return paths;
    }

    public String[] getDocumentPaths(String path, boolean includeSubPaths, String documentPattern) throws IOException {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (documentPattern == null || documentPattern.length() == 0) {
            documentPattern = "*";
        }
        StringBuilder pattern = new StringBuilder(128);
        pattern.append(path).append(includeSubPaths ? "**/" : "").append(documentPattern);
        List<String> documentPaths = this.matchDocumentPaths(pattern.toString());
        return documentPaths.toArray(new String[documentPaths.size()]);
    }

    public String[] getDescriptionDocumentPaths() throws IOException {
        return this.getDocumentPaths("/", true, "*.desc.xml");
    }

    public String[] getScriptDocumentPaths(WebScript script) throws IOException {
        String scriptPaths = script.getDescription().getId() + ".*";
        return this.getDocumentPaths("/", false, scriptPaths);
    }

    public ScriptLoader getScriptLoader() {
        return new WebApplicationStoreScriptLoader();
    }

    public TemplateLoader getTemplateLoader() {
        return new WebApplicationStoreTemplateLoader();
    }

    public String getBasePath() {
        return this.getRoot();
    }

    protected Resource[] getDocumentResources(String documentPathPattern) throws IOException {
        String resourcePath = this.toResourcePath(documentPathPattern);
        Resource[] resources = this.resolver.getResources(resourcePath);
        ArrayList<Resource> list = new ArrayList<Resource>(resources.length);
        for (Resource resource : resources) {
            if (resource.getURL().toExternalForm().endsWith("/")) continue;
            list.add(resource);
        }
        return list.toArray(new Resource[list.size()]);
    }

    private class WebApplicationStoreScriptContent
    implements ScriptContent {
        private String scriptPath;

        private WebApplicationStoreScriptContent(String path) {
            this.scriptPath = path;
        }

        public String getPath() {
            return ResourceStore.this.getBasePath() + '/' + this.scriptPath;
        }

        public String getPathDescription() {
            return ResourceStore.this.getBasePath() + '/' + this.scriptPath;
        }

        public InputStream getInputStream() {
            InputStream is = null;
            try {
                String resourcePath = ResourceStore.this.toResourcePath(this.scriptPath);
                Resource resource = ResourceStore.this.getResourceResolver().getResource(resourcePath);
                if (resource.exists()) {
                    is = resource.getInputStream();
                }
            }
            catch (IOException e) {
                throw new PlatformRuntimeException("Unable to load script: " + this.scriptPath, (Throwable)e);
            }
            return is;
        }

        public Reader getReader() {
            InputStreamReader reader = null;
            try {
                String resourcePath = ResourceStore.this.toResourcePath(this.scriptPath);
                Resource resource = ResourceStore.this.getResourceResolver().getResource(resourcePath);
                if (resource.exists()) {
                    reader = new InputStreamReader(resource.getInputStream());
                }
            }
            catch (IOException e) {
                throw new PlatformRuntimeException("Unable to load script: " + this.scriptPath, (Throwable)e);
            }
            return reader;
        }

        public boolean isSecure() {
            return false;
        }

        public boolean isCachable() {
            return false;
        }
    }

    private class WebApplicationStoreTemplateSource {
        private String templatePath;

        private WebApplicationStoreTemplateSource(String path) {
            this.templatePath = path;
        }

        private long lastModified() {
            try {
                return ResourceStore.this.lastModified(this.templatePath);
            }
            catch (IOException e) {
                return -1L;
            }
        }

        private Reader getReader(String encoding) throws IOException {
            InputStreamReader reader = null;
            String resourcePath = ResourceStore.this.toResourcePath(this.templatePath);
            Resource resource = ResourceStore.this.getResourceResolver().getResource(resourcePath);
            if (resource.exists()) {
                reader = new InputStreamReader(resource.getInputStream());
            }
            return reader;
        }
    }

    private class WebApplicationStoreTemplateLoader
    implements TemplateLoader {
        private WebApplicationStoreTemplateLoader() {
        }

        public void closeTemplateSource(Object templateSource) throws IOException {
        }

        public Object findTemplateSource(String name) throws IOException {
            WebApplicationStoreTemplateSource source = null;
            if (ResourceStore.this.hasDocument(name)) {
                source = new WebApplicationStoreTemplateSource(name);
            }
            return source;
        }

        public long getLastModified(Object templateSource) {
            return ((WebApplicationStoreTemplateSource)templateSource).lastModified();
        }

        public Reader getReader(Object templateSource, String encoding) throws IOException {
            return ((WebApplicationStoreTemplateSource)templateSource).getReader(encoding);
        }
    }

    protected class WebApplicationStoreScriptLoader
    implements ScriptLoader {
        protected WebApplicationStoreScriptLoader() {
        }

        public ScriptContent getScript(String path) {
            WebApplicationStoreScriptContent sc = null;
            if (ResourceStore.this.hasDocument(path)) {
                sc = new WebApplicationStoreScriptContent(path);
            }
            return sc;
        }
    }
}

