/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.extensions.webscripts.Store;
import org.springframework.util.StringUtils;

public class StoreResource
extends AbstractResource {
    private final Store store;
    private final String path;

    public StoreResource(Store store, String path) {
        this.store = store;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = StringUtils.cleanPath((String)path);
    }

    public final Store getStore() {
        return this.store;
    }

    public final String getPath() {
        return this.path;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = this.store.getDocument(this.path);
        if (is == null) {
            throw new FileNotFoundException("Could not open " + this.getDescription());
        }
        return is;
    }

    public String getFilename() {
        return StringUtils.getFilename((String)this.path);
    }

    public String getDescription() {
        return "Store resource [" + this.path + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StoreResource) {
            StoreResource otherRes = (StoreResource)((Object)obj);
            return this.store.equals(otherRes.getStore()) && this.path.equals(otherRes.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public Resource createRelative(String relativePath) throws IOException {
        String newPath = this.getPath();
        int i = newPath.lastIndexOf("/");
        newPath = newPath.substring(0, i);
        if (!relativePath.startsWith("/")) {
            newPath = newPath + "/";
        }
        newPath = newPath + relativePath;
        return new StoreResource(this.getStore(), newPath);
    }
}

