/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.connectors.xmlrpc;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.chiba.connectors.xmlrpc.RPCClient;
import org.chiba.xml.xforms.connector.AbstractConnector;
import org.chiba.xml.xforms.connector.SubmissionHandler;
import org.chiba.xml.xforms.connector.serializer.XMLSerializer;
import org.chiba.xml.xforms.core.Submission;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Node;

public class XMLRPCSubmissionHandler
extends AbstractConnector
implements SubmissionHandler {
    private static Logger log = Logger.getLogger(XMLRPCSubmissionHandler.class);

    public XMLRPCSubmissionHandler() throws XFormsException {
        this.registerSerializer("xmlrpc", "put", "*", new XMLSerializer());
    }

    public Map submit(Submission submission, Node instance) throws XFormsException {
        if (!submission.getReplace().equals("none")) {
            throw new XFormsException("submission mode '" + submission.getReplace() + "' not supported");
        }
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.serialize(submission, instance, stream);
            log.setLevel(Level.DEBUG);
            URI uri = new URI(this.getURI());
            log.debug((Object)("Getting URI: '" + uri + "'"));
            Vector v = this.parseURI(uri);
            String rpcURL = (String)v.get(0);
            String function = (String)v.get(1);
            Hashtable params = (Hashtable)v.get(2);
            params.put("doc", stream.toByteArray());
            RPCClient rpc = new RPCClient(rpcURL);
            Hashtable result = rpc.runFunc(function, params);
            if (((String)result.get("status")).equals("error")) {
                throw new XFormsException((String)result.get("error"));
            }
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
        return null;
    }

    private Vector parseURI(URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String query = uri.getQuery();
        int finalSlash = path.lastIndexOf(47);
        String basePath = "";
        if (finalSlash > 0) {
            basePath = path.substring(1, finalSlash);
        }
        String function = path.substring(finalSlash + 1, path.length());
        String rpcURL = "http://" + host + ":" + port + "/" + basePath;
        log.debug((Object)("New URL  = " + rpcURL));
        log.debug((Object)("Function = " + function));
        Hashtable<String, String> paramHash = new Hashtable<String, String>();
        if (query != null) {
            String[] params = query.split("&");
            for (int i = 0; i < params.length; ++i) {
                log.debug((Object)("params[" + i + "] = " + params[i]));
                String[] keyval = params[i].split("=");
                log.debug((Object)("\t" + keyval[0] + " -> " + keyval[1]));
                paramHash.put(keyval[0], keyval[1]);
            }
        }
        Vector<Object> ret = new Vector<Object>();
        ret.add(rpcURL);
        ret.add(function);
        ret.add(paramHash);
        return ret;
    }
}

