/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.xs.XSModel;
import org.chiba.xml.events.XMLEventService;
import org.chiba.xml.xforms.ChibaBean;
import org.chiba.xml.xforms.CustomElementFactory;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.XFormsElementFactory;
import org.chiba.xml.xforms.config.XFormsConfigException;
import org.chiba.xml.xforms.connector.ConnectorFactory;
import org.chiba.xml.xforms.core.BindingResolver;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsErrorIndication;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class Container {
    private static Logger LOGGER = Logger.getLogger(Container.class);
    private BindingResolver bindingResolver;
    private ChibaBean processor;
    private ConnectorFactory connectorFactory;
    private Document document;
    private XSModel schema;
    private Element root;
    private XMLEventService eventService;
    private JXPathContext rootContext;
    private List models;
    private Map xFormsElements;
    private XFormsElementFactory elementFactory;
    private CustomElementFactory customElementFactory;
    private boolean modelConstructDone = false;
    private int idCounter = 0;
    private List eventExceptions;

    public Container(ChibaBean processor) {
        this.processor = processor;
    }

    public ChibaBean getProcessor() {
        return this.processor;
    }

    public BindingResolver getBindingResolver() {
        if (this.bindingResolver == null) {
            this.bindingResolver = new BindingResolver();
        }
        return this.bindingResolver;
    }

    public ConnectorFactory getConnectorFactory() {
        if (this.connectorFactory == null) {
            try {
                this.connectorFactory = ConnectorFactory.getFactory();
                this.connectorFactory.setContext(this.processor.getContext());
            }
            catch (XFormsConfigException xce) {
                throw new RuntimeException(xce);
            }
        }
        return this.connectorFactory;
    }

    public XFormsElementFactory getElementFactory() {
        if (this.elementFactory == null) {
            this.elementFactory = new XFormsElementFactory();
        }
        return this.elementFactory;
    }

    public CustomElementFactory getCustomElementFactory() throws XFormsException {
        if (this.customElementFactory == null) {
            this.customElementFactory = new CustomElementFactory();
        }
        return this.customElementFactory;
    }

    public XMLEventService getXMLEventService() {
        return this.eventService;
    }

    public void setXMLEventService(XMLEventService eventService) {
        this.eventService = eventService;
    }

    public void setDocument(Document document) {
        this.document = document;
        this.root = this.document.getDocumentElement();
        if (!this.root.hasAttributeNS("http://www.w3.org/2000/xmlns/", "chiba")) {
            this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:chiba", "http://chiba.sourceforge.net/xforms");
        }
        this.rootContext = JXPathContext.newContext((Object)this.root);
    }

    public Document getDocument() {
        return this.document;
    }

    public void setExternalSchema(XSModel schema) {
        this.schema = schema;
    }

    public XSModel getExternalSchema() {
        return this.schema;
    }

    public JXPathContext getRootContext() {
        return this.rootContext;
    }

    public void init() throws XFormsException {
        ((ElementImpl)this.root).setUserData((Object)this);
        LOGGER.info((Object)("processing XForms " + this.getVersion()));
        this.initModels();
    }

    public String getVersion() {
        Node defaultModel = this.root.getElementsByTagNameNS("http://www.w3.org/2002/xforms", "model").item(0);
        String version = "1.0";
        if (defaultModel.getNodeType() == 1 && XFormsElement.getXFormsAttribute((Element)defaultModel, "version") != null) {
            return XFormsElement.getXFormsAttribute((Element)defaultModel, "version");
        }
        return version;
    }

    public void shutdown() throws XFormsException {
        if (this.models != null) {
            int index = 0;
            while (index < this.models.size()) {
                Model model = (Model)this.models.get(index);
                this.dispatch(model.getTarget(), "xforms-model-destruct", null);
                ++index;
            }
        }
    }

    public void addEventListener(String targetId, String eventType, EventListener eventListener, boolean useCapture) throws XFormsException {
        EventTarget eventTarget = this.lookupEventTarget(targetId);
        if (eventTarget != null) {
            eventTarget.addEventListener(eventType, eventListener, useCapture);
            return;
        }
        throw new XFormsException("event target '" + targetId + "' not found");
    }

    public void removeEventListener(String targetId, String eventType, EventListener eventListener, boolean useCapture) throws XFormsException {
        EventTarget eventTarget = this.lookupEventTarget(targetId);
        if (eventTarget != null) {
            eventTarget.addEventListener(eventType, eventListener, useCapture);
            return;
        }
        throw new XFormsException("event target '" + targetId + "' not found");
    }

    public boolean dispatch(String targetId, String eventType) throws XFormsException {
        return this.dispatch(targetId, eventType, null);
    }

    public boolean dispatch(String targetId, String eventType, Object info) throws XFormsException {
        return this.dispatch(targetId, eventType, info, true, true);
    }

    public boolean dispatch(String targetId, String eventType, Object info, boolean bubbles, boolean cancelable) throws XFormsException {
        EventTarget eventTarget = this.lookupEventTarget(targetId);
        if (eventTarget != null) {
            return this.dispatch(eventTarget, eventType, info, bubbles, cancelable);
        }
        throw new XFormsException("event target '" + targetId + "' not found");
    }

    public boolean dispatch(EventTarget eventTarget, String eventType, Object info) throws XFormsException {
        return this.dispatch(eventTarget, eventType, info, true, true);
    }

    public boolean dispatch(EventTarget eventTarget, String eventType, Object info, boolean bubbles, boolean cancelable) throws XFormsException {
        boolean result = false;
        XFormsException xFormsException = null;
        try {
            result = this.eventService.dispatch(eventTarget, eventType, bubbles, cancelable, info);
        }
        finally {
            if (this.eventExceptions != null && this.eventExceptions.size() > 0) {
                Exception exception = (Exception)this.eventExceptions.get(0);
                if (exception instanceof XFormsErrorIndication) {
                    if (((XFormsErrorIndication)exception).isFatal()) {
                        xFormsException = (XFormsException)exception;
                    } else {
                        LOGGER.warn((Object)"dispatch: non-fatal xforms error", (Throwable)exception);
                    }
                } else {
                    xFormsException = exception instanceof XFormsException ? (XFormsException)exception : new XFormsException(exception);
                }
                this.eventExceptions.clear();
            }
        }
        if (xFormsException != null) {
            LOGGER.error((Object)"dispatch: exception during event flow", xFormsException);
            throw xFormsException;
        }
        return result;
    }

    public void handleEventException(Exception exception) {
        XFormsErrorIndication indication;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("handle event exception: " + exception.getClass().getName() + " kept for rethrowal after dispatch() has finished"));
        }
        if (this.eventExceptions == null) {
            this.eventExceptions = new ArrayList();
        }
        if (exception instanceof XFormsErrorIndication && !(indication = (XFormsErrorIndication)exception).isHandled()) {
            try {
                this.dispatch(indication.getEventTarget(), indication.getEventType(), indication.getContextInfo());
            }
            catch (XFormsException e) {
                LOGGER.error((Object)"handle event exception: exception during error indication event", (Throwable)e);
            }
            indication.setHandled();
        }
        this.eventExceptions.add(exception);
    }

    public XFormsElement lookup(String id) {
        if (this.xFormsElements != null) {
            return (XFormsElement)this.xFormsElements.get(id);
        }
        return null;
    }

    public String generateId() {
        String id = "C" + ++this.idCounter;
        while (this.lookup(id) != null) {
            id = "C" + ++this.idCounter;
        }
        return id;
    }

    public void register(XFormsElement element) {
        if (this.xFormsElements == null) {
            this.xFormsElements = new HashMap();
        }
        this.xFormsElements.put(element.getId(), element);
    }

    public void deregister(XFormsElement element) {
        if (this.xFormsElements != null) {
            this.xFormsElements.remove(element.getId());
        }
    }

    public Model getDefaultModel() throws XFormsException {
        return this.getModel(null);
    }

    public Model getModel(String id) throws XFormsException {
        if (id == null || id.length() == 0) {
            if (this.models != null && this.models.size() > 0) {
                return (Model)this.models.get(0);
            }
            throw new XFormsException("default model not found");
        }
        if (this.models != null) {
            int index = 0;
            while (index < this.models.size()) {
                Model model = (Model)this.models.get(index);
                if (model.getId().equals(id)) {
                    return model;
                }
                ++index;
            }
        }
        throw new XFormsException("model '" + id + "' not found");
    }

    public List getModels() {
        return this.models;
    }

    public boolean isModelConstructDone() {
        return this.modelConstructDone;
    }

    private void initModels() throws XFormsException {
        Model model;
        this.models = new ArrayList();
        NodeList nl = this.root.getElementsByTagNameNS("http://www.w3.org/2002/xforms", "model");
        int i = 0;
        while (i < nl.getLength()) {
            Element modelElement = (Element)nl.item(i);
            model = (Model)this.getElementFactory().createXFormsElement(modelElement, null);
            model.init();
            if (this.schema != null) {
                model.getSchemas().add(this.schema);
            }
            this.models.add(model);
            this.dispatch(model.getTarget(), "xforms-model-construct", null);
            ++i;
        }
        i = 0;
        while (i < nl.getLength()) {
            model = (Model)this.models.get(i);
            this.dispatch(model.getTarget(), "xforms-model-construct-done", null);
            this.modelConstructDone = true;
            ++i;
        }
        i = 0;
        while (i < nl.getLength()) {
            model = (Model)this.models.get(i);
            this.dispatch(model.getTarget(), "xforms-ready", null);
            ++i;
        }
    }

    private EventTarget lookupEventTarget(String id) {
        Pointer pointer;
        XFormsElement xFormsElement = this.lookup(id);
        if (xFormsElement != null) {
            return xFormsElement.getTarget();
        }
        if (this.rootContext != null && (pointer = this.rootContext.getPointer("//*[@id='" + id + "']")) != null) {
            return (EventTarget)pointer.getNode();
        }
        return null;
    }
}

