/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms;

import java.util.Arrays;
import java.util.List;
import org.apache.xerces.dom.ElementImpl;
import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.ns.NamespaceResolver;
import org.chiba.xml.xforms.XFormsConstants;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.action.ActionAction;
import org.chiba.xml.xforms.action.DeleteAction;
import org.chiba.xml.xforms.action.DispatchAction;
import org.chiba.xml.xforms.action.InsertAction;
import org.chiba.xml.xforms.action.LoadAction;
import org.chiba.xml.xforms.action.MessageAction;
import org.chiba.xml.xforms.action.RebuildAction;
import org.chiba.xml.xforms.action.RecalculateAction;
import org.chiba.xml.xforms.action.RefreshAction;
import org.chiba.xml.xforms.action.ResetAction;
import org.chiba.xml.xforms.action.RevalidateAction;
import org.chiba.xml.xforms.action.ScriptAction;
import org.chiba.xml.xforms.action.SendAction;
import org.chiba.xml.xforms.action.SetFocusAction;
import org.chiba.xml.xforms.action.SetIndexAction;
import org.chiba.xml.xforms.action.SetValueAction;
import org.chiba.xml.xforms.action.ToggleAction;
import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.core.Bind;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.Submission;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.Case;
import org.chiba.xml.xforms.ui.Choices;
import org.chiba.xml.xforms.ui.Common;
import org.chiba.xml.xforms.ui.Copy;
import org.chiba.xml.xforms.ui.Extension;
import org.chiba.xml.xforms.ui.Filename;
import org.chiba.xml.xforms.ui.Group;
import org.chiba.xml.xforms.ui.Item;
import org.chiba.xml.xforms.ui.Itemset;
import org.chiba.xml.xforms.ui.Mediatype;
import org.chiba.xml.xforms.ui.Output;
import org.chiba.xml.xforms.ui.Range;
import org.chiba.xml.xforms.ui.Repeat;
import org.chiba.xml.xforms.ui.RepeatItem;
import org.chiba.xml.xforms.ui.Selector;
import org.chiba.xml.xforms.ui.Submit;
import org.chiba.xml.xforms.ui.Switch;
import org.chiba.xml.xforms.ui.Text;
import org.chiba.xml.xforms.ui.Trigger;
import org.chiba.xml.xforms.ui.Upload;
import org.chiba.xml.xforms.ui.Value;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XFormsElementFactory
implements XFormsConstants {
    private static final String[] ACTION_ELEMENTS = new String[]{"action", "dispatch", "rebuild", "recalculate", "revalidate", "refresh", "setfocus", "load", "setvalue", "send", "reset", "message", "toggle", "insert", "delete", "setindex"};
    private static final String[] FORM_CONTROLS = new String[]{"group", "input", "secret", "textarea", "output", "upload", "range", "trigger", "submit", "select", "select1"};
    private static final String[] UI_ELEMENTS = new String[]{"extension", "choices", "item", "value", "filename", "mediatype", "label", "help", "hint", "alert", "switch", "case", "repeat", "itemset", "copy"};
    private static final List ACTION_ELEMENT_LIST = Arrays.asList(ACTION_ELEMENTS);
    private static final List FORM_CONTROL_LIST = Arrays.asList(FORM_CONTROLS);
    private static final List UI_ELEMENT_LIST = Arrays.asList(UI_ELEMENTS);

    public static boolean isActionElement(Element element) {
        String name = element.getLocalName();
        String uri = element.getNamespaceURI();
        if (name.equals("script")) {
            return true;
        }
        return "http://www.w3.org/2002/xforms".equals(uri) && ACTION_ELEMENT_LIST.contains(name);
    }

    public static boolean isBindElement(Element element) {
        String name = element.getLocalName();
        String uri = element.getNamespaceURI();
        return "http://www.w3.org/2002/xforms".equals(uri) && "bind".equals(name);
    }

    public static boolean isSubmissionElement(Element element) {
        String name = element.getLocalName();
        String uri = element.getNamespaceURI();
        return "http://www.w3.org/2002/xforms".equals(uri) && "submission".equals(name);
    }

    public static boolean isUIElement(Element element) {
        if (XFormsElementFactory.hasRepeatAttributes(element)) {
            return true;
        }
        String name = element.getLocalName();
        String uri = element.getNamespaceURI();
        return "http://www.w3.org/2002/xforms".equals(uri) && (UI_ELEMENT_LIST.contains(name) || FORM_CONTROL_LIST.contains(name));
    }

    public XFormsElement createXFormsElement(Element element, Model model) throws XFormsException {
        XFormsElement xformsElement;
        String localName = element.getLocalName();
        if (localName.equals("model")) {
            xformsElement = new Model(element);
        } else if (localName.equals("instance")) {
            xformsElement = new Instance(element, model);
        } else if (localName.equals("bind")) {
            xformsElement = new Bind(element, model);
        } else if (localName.equals("submission")) {
            xformsElement = new Submission(element, model);
        } else if (localName.equals("extension")) {
            xformsElement = new Extension(element, model);
        } else if (localName.equals("input") || localName.equals("secret") || localName.equals("textarea")) {
            XFormsElementFactory.generateDefaultAlert(element);
            xformsElement = new Text(element, model);
        } else if (localName.equals("output")) {
            xformsElement = new Output(element, model);
        } else if (localName.equals("upload")) {
            XFormsElementFactory.generateDefaultAlert(element);
            xformsElement = new Upload(element, model);
        } else if (localName.equals("range")) {
            XFormsElementFactory.generateDefaultAlert(element);
            xformsElement = new Range(element, model);
        } else if (localName.equals("trigger")) {
            XFormsElementFactory.generateDefaultAlert(element);
            xformsElement = new Trigger(element, model);
        } else if (localName.equals("submit")) {
            XFormsElementFactory.generateDefaultAlert(element);
            xformsElement = new Submit(element, model);
        } else if (localName.equals("select")) {
            XFormsElementFactory.generateDefaultAlert(element);
            Selector selector = new Selector(element, model);
            selector.setMultiple(true);
            xformsElement = selector;
        } else if (localName.equals("select1")) {
            XFormsElementFactory.generateDefaultAlert(element);
            Selector selector = new Selector(element, model);
            selector.setMultiple(false);
            xformsElement = selector;
        } else if (localName.equals("choices")) {
            xformsElement = new Choices(element, model);
        } else if (localName.equals("item")) {
            XFormsElementFactory.generateDefaultAlert(element);
            xformsElement = new Item(element, model);
        } else if (localName.equals("value")) {
            xformsElement = new Value(element, model);
        } else if (localName.equals("filename")) {
            xformsElement = new Filename(element, model);
        } else if (localName.equals("mediatype")) {
            xformsElement = new Mediatype(element, model);
        } else if (localName.equals("label") || localName.equals("help") || localName.equals("hint") || localName.equals("alert")) {
            xformsElement = new Common(element, model);
        } else if (localName.equals("group")) {
            if (element.getAttributeNS(null, "appearance").equals("repeated")) {
                xformsElement = new RepeatItem(element, model);
            } else {
                XFormsElementFactory.generateDefaultAlert(element);
                xformsElement = new Group(element, model);
            }
        } else if (localName.equals("switch")) {
            xformsElement = new Switch(element, model);
        } else if (localName.equals("case")) {
            xformsElement = new Case(element, model);
        } else if (localName.equals("repeat") || XFormsElementFactory.hasRepeatAttributes(element)) {
            xformsElement = new Repeat(element, model);
        } else if (localName.equals("itemset")) {
            XFormsElementFactory.generateDefaultAlert(element);
            xformsElement = new Itemset(element, model);
        } else if (localName.equals("copy")) {
            xformsElement = new Copy(element, model);
        } else if (localName.equals("action")) {
            xformsElement = new ActionAction(element, model);
        } else if (localName.equals("dispatch")) {
            xformsElement = new DispatchAction(element, model);
        } else if (localName.equals("rebuild")) {
            xformsElement = new RebuildAction(element, model);
        } else if (localName.equals("recalculate")) {
            xformsElement = new RecalculateAction(element, model);
        } else if (localName.equals("revalidate")) {
            xformsElement = new RevalidateAction(element, model);
        } else if (localName.equals("refresh")) {
            xformsElement = new RefreshAction(element, model);
        } else if (localName.equals("setfocus")) {
            xformsElement = new SetFocusAction(element, model);
        } else if (localName.equals("load")) {
            xformsElement = new LoadAction(element, model);
        } else if (localName.equals("setvalue")) {
            xformsElement = new SetValueAction(element, model);
        } else if (localName.equals("send")) {
            xformsElement = new SendAction(element, model);
        } else if (localName.equals("reset")) {
            xformsElement = new ResetAction(element, model);
        } else if (localName.equals("message")) {
            xformsElement = new MessageAction(element, model);
        } else if (localName.equals("toggle")) {
            xformsElement = new ToggleAction(element, model);
        } else if (localName.equals("insert")) {
            xformsElement = new InsertAction(element, model);
        } else if (localName.equals("delete")) {
            xformsElement = new DeleteAction(element, model);
        } else if (localName.equals("setindex")) {
            xformsElement = new SetIndexAction(element, model);
        } else if (localName.equals("script")) {
            xformsElement = new ScriptAction(element, model);
        } else {
            return null;
        }
        ((ElementImpl)element).setUserData((Object)xformsElement);
        return xformsElement;
    }

    public static boolean hasRepeatAttributes(Element element) {
        return element.hasAttributeNS("http://www.w3.org/2002/xforms", "repeat-model") || element.hasAttributeNS("http://www.w3.org/2002/xforms", "repeat-bind") || element.hasAttributeNS("http://www.w3.org/2002/xforms", "repeat-nodeset");
    }

    public static boolean generateDefaultAlert(Element element) throws XFormsException {
        if (Boolean.valueOf(Config.getInstance().getProperty("chiba.ui.generateDefaultAlerts", "false")).booleanValue() && DOMUtil.findFirstChildNS(element, "http://www.w3.org/2002/xforms", "alert") == null) {
            String alertText = Config.getInstance().getProperty("chiba.ui.defaultAlertText", "The specified value is invalid");
            Document document = element.getOwnerDocument();
            String xformsPrefix = NamespaceResolver.getPrefix(element, "http://www.w3.org/2002/xforms");
            Element alertElement = document.createElementNS("http://www.w3.org/2002/xforms", xformsPrefix + ":" + "alert");
            alertElement.appendChild(document.createTextNode(alertText));
            element.appendChild(alertElement);
            return true;
        }
        return false;
    }
}

