/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.action;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.action.XFormsAction;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.UpdateHandler;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xpath.XPathUtil;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public abstract class AbstractAction
extends XFormsElement
implements EventListener,
XFormsAction {
    protected String repeatItemId;
    protected String eventType;

    public AbstractAction(Element element, Model model) {
        super(element, model);
    }

    public void setRepeatItemId(String repeatItemId) throws XFormsException {
        this.repeatItemId = repeatItemId;
    }

    public String getRepeatItemId() {
        return this.repeatItemId;
    }

    public boolean isRepeated() {
        return this.repeatItemId != null;
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeAction();
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeAction();
    }

    protected final void initializeAction() {
        if (!(this.getParentObject() instanceof XFormsAction)) {
            String event = this.element.getAttributeNS("http://www.w3.org/2001/xml-events", "event");
            if (event.length() == 0) {
                event = "DOMActivate";
            }
            this.eventType = event;
            XFormsElement parent = this.getParentObject();
            parent.getTarget().addEventListener(this.eventType, this, false);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " init: added handler for event '" + this.eventType + "' to " + parent));
            }
        }
    }

    protected final void disposeAction() {
        if (!(this.getParentObject() instanceof XFormsAction)) {
            XFormsElement parent = this.getParentObject();
            parent.getTarget().removeEventListener(this.eventType, this, false);
        }
    }

    public void handleEvent(Event event) {
        try {
            if (event.getType().equals(this.eventType)) {
                if (this.getLogger().isDebugEnabled()) {
                    String phase = "";
                    switch (event.getEventPhase()) {
                        case 1: {
                            phase = "capturing phase";
                            break;
                        }
                        case 2: {
                            phase = "at target";
                            break;
                        }
                        case 3: {
                            phase = "bubbling phase";
                        }
                    }
                    this.getLogger().debug((Object)(this + " handling event '" + this.eventType + "' (" + phase + ")"));
                }
                if (this.execute(this.element)) {
                    this.perform();
                }
            }
        }
        catch (Exception e) {
            this.container.handleEventException(e);
            event.preventDefault();
            event.stopPropagation();
        }
    }

    protected boolean execute(Element action) {
        String ifCondition = XFormsElement.getXFormsAttribute(action, "if");
        if (ifCondition == null) {
            return true;
        }
        return this.evalIfCondition(action, ifCondition);
    }

    protected boolean evalIfCondition(Element action, String ifCondition) {
        Boolean b;
        JXPathContext context = this.model.getDefaultInstance().getInstanceContext();
        String currentPath = this.getParentContextPath(action);
        if (currentPath == null) {
            try {
                b = (Boolean)context.getValue(ifCondition);
            }
            catch (JXPathException jxe) {
                jxe.printStackTrace();
                return true;
            }
        } else {
            String expr = XPathUtil.joinStep(new String[]{currentPath, ifCondition});
            b = (Boolean)context.getValue("boolean(" + expr + ")");
        }
        return b;
    }

    protected final void doRebuild(boolean rebuild) throws XFormsException {
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler != null) {
            updateHandler.doRebuild(rebuild);
            return;
        }
        if (rebuild) {
            this.container.dispatch(this.model.getTarget(), "xforms-rebuild", null);
        }
    }

    protected final void doRecalculate(boolean recalculate) throws XFormsException {
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler != null) {
            updateHandler.doRecalculate(recalculate);
            return;
        }
        if (recalculate) {
            this.container.dispatch(this.model.getTarget(), "xforms-recalculate", null);
        }
    }

    protected final void doRevalidate(boolean revalidate) throws XFormsException {
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler != null) {
            updateHandler.doRevalidate(revalidate);
            return;
        }
        if (revalidate) {
            this.container.dispatch(this.model.getTarget(), "xforms-revalidate", null);
        }
    }

    protected final void doRefresh(boolean refresh) throws XFormsException {
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler != null) {
            updateHandler.doRefresh(refresh);
            return;
        }
        if (refresh) {
            this.container.dispatch(this.model.getTarget(), "xforms-refresh", null);
        }
    }
}

