/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.action;

import java.util.HashMap;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.action.AbstractBoundAction;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.exception.XFormsLinkError;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MessageAction
extends AbstractBoundAction {
    private static Logger LOGGER = Logger.getLogger(MessageAction.class);
    private String levelAttribute;
    private String textContent;

    public MessageAction(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        Node child;
        super.init();
        this.levelAttribute = this.getXFormsAttribute("level");
        if (this.levelAttribute == null) {
            this.getLogger().warn((Object)(this + " init: required level attribute missing, assuming 'modal'"));
            this.levelAttribute = "modal";
        }
        this.textContent = (child = this.element.getFirstChild()) != null && child.getNodeType() == 3 ? child.getNodeValue() : "";
    }

    public void perform() throws XFormsException {
        String bindAttribute = this.getXFormsAttribute("bind");
        String refAttribute = this.getXFormsAttribute("ref");
        String srcAttribute = this.getXFormsAttribute("src");
        String message = "";
        if (bindAttribute != null || refAttribute != null) {
            message = this.model.getInstance(this.getInstanceId()).getNodeValue(this.getLocationPath());
        } else {
            if (srcAttribute != null) {
                Object result;
                try {
                    result = this.container.getConnectorFactory().createURIResolver(srcAttribute, this.element).resolve();
                }
                catch (Exception e) {
                    throw new XFormsLinkError("uri resolution failed at " + this, e, this.model.getTarget(), srcAttribute);
                }
                try {
                    message = JXPathContext.newContext((Object)result).getValue("/").toString();
                }
                catch (Exception e) {
                    throw new XFormsLinkError("object model not supported at " + this, e, this.model.getTarget(), srcAttribute);
                }
            }
            message = this.textContent;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("message", message);
        map.put("level", this.levelAttribute);
        this.container.dispatch(this.target, "chiba-render-message", map);
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

