/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.connector.serializer;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import org.chiba.xml.xforms.connector.InstanceSerializer;
import org.chiba.xml.xforms.core.Submission;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UrlEncodedSerializer
implements InstanceSerializer {
    public void serialize(Submission submission, Node instance, OutputStream stream, String defaultEncoding) throws Exception {
        if (instance == null) {
            return;
        }
        switch (instance.getNodeType()) {
            case 1: {
                break;
            }
            case 9: {
                instance = ((Document)instance).getDocumentElement();
                break;
            }
            default: {
                return;
            }
        }
        String separator = "&";
        if (submission.getSeparator() != null) {
            separator = submission.getSeparator();
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, defaultEncoding)));
        this.serializeNode(writer, instance, separator);
        writer.flush();
    }

    protected void serializeNode(Writer writer, Node node, String separator) throws Exception {
        String textValue = null;
        boolean ignoreTextNodes = false;
        NodeList list = node.getChildNodes();
        block4: for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            switch (n.getNodeType()) {
                case 3: {
                    if (ignoreTextNodes) continue block4;
                    if (textValue != null) {
                        ignoreTextNodes = true;
                        continue block4;
                    }
                    textValue = n.getNodeValue();
                    continue block4;
                }
                case 1: {
                    ignoreTextNodes = true;
                    this.serializeNode(writer, n, separator);
                    continue block4;
                }
            }
        }
        if (!ignoreTextNodes && textValue != null && textValue.length() > 0) {
            String name = node.getLocalName();
            if (name == null) {
                name = node.getNodeName();
            }
            writer.write(URLEncoder.encode(name, "UTF-8") + "=" + URLEncoder.encode(textValue, "UTF-8") + separator);
        }
        writer.flush();
    }
}

