/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.constraints;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.NodeImpl;
import org.chiba.xml.xforms.constraints.CalculateVertex;
import org.chiba.xml.xforms.constraints.ConstraintVertex;
import org.chiba.xml.xforms.constraints.DependencyGraph;
import org.chiba.xml.xforms.constraints.ReadonlyVertex;
import org.chiba.xml.xforms.constraints.RelevantVertex;
import org.chiba.xml.xforms.constraints.RequiredVertex;
import org.chiba.xml.xforms.constraints.Vertex;

public class SubGraph
extends DependencyGraph {
    protected static Logger LOGGER = Logger.getLogger(SubGraph.class);

    public void constructSubDependencyGraph(List changedVertices) {
        this.constructSubDependencyGraph(null, changedVertices);
    }

    private void constructSubDependencyGraph(Vertex clonedParent, List changedVertices) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("constructSubDependencyGraph: processing " + (clonedParent != null ? clonedParent + " with " : "") + changedVertices.size() + " changed vertices"));
        }
        for (Vertex originalVertex : changedVertices) {
            int index = this.vertices.indexOf(originalVertex);
            if (index < 0) {
                Vertex clonedVertex = this.createSubVertex(originalVertex.relativeContext, originalVertex.instanceNode, originalVertex.xpathExpression, originalVertex.getVertexType());
                this.vertices.add(clonedVertex);
                if (clonedParent != null) {
                    clonedParent.addDep(clonedVertex);
                }
                if (originalVertex.depList == null) continue;
                this.constructSubDependencyGraph(clonedVertex, originalVertex.depList);
                continue;
            }
            if (clonedParent == null) continue;
            clonedParent.addDep((Vertex)this.vertices.elementAt(index));
        }
    }

    private Vertex createSubVertex(JXPathContext relativeContext, NodeImpl instanceNode, String expression, short property) {
        Vertex v = null;
        switch (property) {
            case 1: {
                v = new CalculateVertex(relativeContext, instanceNode, expression);
                break;
            }
            case 2: {
                v = new RelevantVertex(relativeContext, instanceNode, expression);
                break;
            }
            case 3: {
                v = new ReadonlyVertex(relativeContext, instanceNode, expression);
                break;
            }
            case 5: {
                v = new ConstraintVertex(relativeContext, instanceNode, expression);
                break;
            }
            case 4: {
                v = new RequiredVertex(relativeContext, instanceNode, expression);
            }
        }
        return v;
    }
}

