/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.core;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPointer;
import org.apache.commons.jxpath.ri.model.dom.DOMNodePointer;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.NodeImpl;
import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.ns.NamespaceResolver;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.core.impl.XercesElementImpl;
import org.chiba.xml.xforms.core.impl.XercesNodeImpl;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.exception.XFormsLinkException;
import org.chiba.xml.xforms.xpath.ExtensionFunctions;
import org.chiba.xml.xpath.XPathUtil;
import org.chiba.xml.xpath.impl.JXPathDOMFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Instance
extends XFormsElement
implements Container {
    private static final Logger LOGGER = Logger.getLogger(Instance.class);
    private Document instanceDocument = null;
    private Element initialInstance = null;
    private JXPathContext instanceContext = null;

    public Instance(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initialInstance = this.getInitiallInstance();
        this.instanceDocument = this.createInstanceDocument();
        this.initInstanceContext();
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.initialInstance = null;
        this.instanceDocument = null;
        this.instanceContext = null;
    }

    protected void initInstanceContext() {
        JXPathDOMFactory factory = new JXPathDOMFactory();
        factory.setNamespaceContext(this.element);
        ExtensionFunctions functions = new ExtensionFunctions();
        functions.setNamespaceContext(this.element);
        this.instanceContext = JXPathContext.newContext((Object)this);
        this.instanceContext.setFactory((AbstractFactory)factory);
        this.instanceContext.setFunctions((Functions)functions);
        Map namespaces = NamespaceResolver.getAllNamespaces(this.element);
        for (String prefix : namespaces.keySet()) {
            String uri = (String)namespaces.get(prefix);
            this.instanceContext.registerNamespace(prefix, uri);
        }
    }

    public ModelItem getModelItem(String locationPath) {
        if (!this.existsNode(locationPath)) {
            return null;
        }
        Pointer pointer = this.instanceContext.getPointer(locationPath);
        NodeImpl node = (NodeImpl)pointer.getNode();
        ModelItem item = (ModelItem)node.getUserData();
        if (item == null) {
            item = this.createModelItem(node);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(this + " get model item: created item for path '" + pointer + "'"));
            }
        }
        return item;
    }

    public Iterator iterateModelItems() {
        return this.iterateModelItems("/");
    }

    public Iterator iterateModelItems(String path) {
        return this.iterateModelItems(path, true);
    }

    public Iterator iterateModelItems(String path, boolean deep) {
        if (!this.existsNode(path)) {
            return null;
        }
        ArrayList list = new ArrayList();
        Iterator iterator = this.instanceContext.iteratePointers(path);
        while (iterator.hasNext()) {
            Object nested;
            Pointer pointer = (Pointer)iterator.next();
            if (pointer instanceof BeanPointer && (nested = pointer.getNode()) instanceof DOMNodePointer) {
                pointer = (Pointer)nested;
            }
            NodeImpl node = (NodeImpl)pointer.getNode();
            this.listModelItems(list, node, deep);
        }
        return list.iterator();
    }

    public String getNodeValue(String path) throws XFormsException {
        ModelItem item = this.getModelItem(path);
        if (item == null) {
            throw new XFormsException("model item for path '" + path + "' does not exist");
        }
        return item.getValue();
    }

    public void setNodeValue(String path, String value) throws XFormsException {
        ModelItem item;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " set node value: " + path + "=" + value));
        }
        if ((item = this.getModelItem(path)) == null) {
            throw new XFormsException("model item for path '" + path + "' does not exist");
        }
        if (!item.isReadonly()) {
            item.setValue(value);
            this.model.addChanged((NodeImpl)item.getNode());
        } else {
            this.getLogger().warn((Object)(this + " set node value: attempt to set readonly value"));
        }
    }

    public boolean existsNode(String path) {
        return this.countNodeset(path) > 0;
    }

    public int countNodeset(String path) {
        return ((Double)this.instanceContext.getValue("count(" + path + ")", Double.class)).intValue();
    }

    public void createNode(String path) throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " create node: " + path));
        }
        try {
            if (this.instanceDocument.getDocumentElement() == null) {
                this.createRootElement(this.instanceDocument, XPathUtil.getFirstPart(path));
            }
            this.instanceContext.createPath(path);
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    public void insertNode(String origin, String before) throws XFormsException {
        String parent;
        ModelItem originItem;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " insert node: " + origin + " before " + before));
            this.getLogger().debug((Object)(this + " insert node: instance data before manipulation" + this.toString(this.instanceDocument)));
        }
        if ((originItem = this.getModelItem(origin)) == null) {
            throw new XFormsException("origin node does not exist");
        }
        Node originNode = (Node)originItem.getNode();
        ModelItem beforeItem = this.getModelItem(before);
        Node beforeNode = null;
        String beforePath = null;
        if (beforeItem != null) {
            beforeNode = (Node)beforeItem.getNode();
            beforePath = before;
        } else {
            String firstSibling = XPathUtil.getNodesetAndPredicates(before)[0] + "[last()]/following-sibling::*[1]";
            beforeItem = this.getModelItem(firstSibling);
            if (beforeItem != null) {
                beforeNode = (Node)beforeItem.getNode();
                beforePath = firstSibling;
            }
        }
        if (beforePath != null) {
            parent = beforePath + "/..";
        } else {
            String[] parentParts = XPathUtil.splitPathExpr(before);
            parent = XPathUtil.joinPathExpr(parentParts, 0, parentParts.length - 1);
        }
        ModelItem parentItem = this.getModelItem(parent);
        if (parentItem == null) {
            throw new XFormsException("parent node does not exist");
        }
        Node parentNode = (Node)parentItem.getNode();
        parentNode.insertBefore(this.instanceDocument.importNode(originNode, true), beforeNode);
        String canonicalPath = this.instanceContext.getPointer(beforeItem != null ? before : parent + "/*[last()]").asPath();
        String[] canonicalParts = XPathUtil.getNodesetAndPredicates(canonicalPath);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nodeset", canonicalParts[0]);
        map.put("position", canonicalParts[1]);
        this.container.dispatch(this.target, "chiba-node-inserted", map);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " insert node: instance data after manipulation" + this.toString(this.instanceDocument)));
        }
    }

    public void deleteNode(String path) throws XFormsException {
        String canonicalPath;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " delete node: " + path));
            this.getLogger().debug((Object)(this + " delete node: instance data before manipulation" + this.toString(this.instanceDocument)));
        }
        try {
            canonicalPath = this.instanceContext.getPointer(path).asPath();
        }
        catch (Exception e) {
            throw new XFormsException("delete node does not exist");
        }
        String[] canonicalParts = XPathUtil.getNodesetAndPredicates(canonicalPath);
        this.instanceContext.removePath(canonicalPath);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nodeset", canonicalParts[0]);
        map.put("position", canonicalParts[1]);
        this.container.dispatch(this.target, "chiba-node-deleted", map);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " delete node: instance data after manipulation" + this.toString(this.instanceDocument)));
        }
    }

    public JXPathContext getInstanceContext() {
        return this.instanceContext;
    }

    void setInstanceDocument(Document document) {
        this.instanceDocument = document;
        this.initInstanceContext();
    }

    public Document getInstanceDocument() {
        return this.instanceDocument;
    }

    public Pointer getPointer(String path) {
        return this.instanceContext.getPointer(path);
    }

    public Iterator getPointerIterator(String path) {
        return this.instanceContext.iteratePointers(path);
    }

    public boolean hasInitialInstance() {
        return this.initialInstance != null;
    }

    public void storeInitialInstance() {
        if (this.initialInstance == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " store initial instance"));
            }
            this.initialInstance = (Element)this.instanceDocument.getDocumentElement().cloneNode(true);
        }
    }

    public void reset() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " reset"));
        }
        this.instanceDocument = this.createInstanceDocument();
    }

    public Object getValue() {
        return this.getInstanceDocument();
    }

    public void setValue(Object value) {
        if (value instanceof Document) {
            this.setInstanceDocument((Document)value);
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    private void createRootElement(Document document, String qname) {
        Element root;
        int separator = qname.indexOf(58);
        if (separator > -1) {
            String prefix = qname.substring(0, separator);
            String uri = NamespaceResolver.getNamespaceURI(this.element, prefix);
            root = document.createElementNS(uri, qname);
        } else {
            root = document.createElement(qname);
        }
        NamespaceResolver.applyNamespaces(this.element, root);
        document.appendChild(root);
    }

    private Element getInitiallInstance() throws XFormsLinkException {
        String srcAttribute = this.getXFormsAttribute("src");
        if (srcAttribute != null) {
            Object result;
            try {
                result = this.container.getConnectorFactory().createURIResolver(srcAttribute, this.element).resolve();
            }
            catch (Exception e) {
                throw new XFormsLinkException("uri resolution failed", e, this.model.getTarget(), srcAttribute);
            }
            if (result instanceof Document) {
                return ((Document)result).getDocumentElement();
            }
            if (result instanceof Element) {
                return (Element)result;
            }
            throw new XFormsLinkException("object model not supported", this.model.getTarget(), (Object)srcAttribute);
        }
        return DOMUtil.getFirstChildElement(this.element);
    }

    private Document createInstanceDocument() throws XFormsException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            Document document = factory.newDocumentBuilder().newDocument();
            if (this.initialInstance != null) {
                document.appendChild(document.importNode(this.initialInstance.cloneNode(true), true));
                String srcAttribute = this.getXFormsAttribute("src");
                if (srcAttribute == null) {
                    NamespaceResolver.applyNamespaces(this.element, document.getDocumentElement());
                }
            }
            return document;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    private ModelItem createModelItem(NodeImpl node) {
        String id = this.model.generateModelItemId();
        XercesNodeImpl modelItem = node.getNodeType() == 1 ? new XercesElementImpl(id) : new XercesNodeImpl(id);
        modelItem.setNode(node);
        NodeImpl parentNode = (NodeImpl)(node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode());
        if (parentNode != null) {
            ModelItem parentItem = (ModelItem)parentNode.getUserData();
            if (parentItem == null) {
                parentItem = this.createModelItem(parentNode);
            }
            modelItem.setParent(parentItem);
        }
        node.setUserData((Object)modelItem);
        return modelItem;
    }

    private void listModelItems(List list, NodeImpl node, boolean deep) {
        ModelItem modelItem = (ModelItem)node.getUserData();
        if (modelItem == null) {
            modelItem = this.createModelItem(node);
        }
        list.add(modelItem);
        if (deep) {
            NamedNodeMap attributes = node.getAttributes();
            for (int index = 0; attributes != null && index < attributes.getLength(); ++index) {
                this.listModelItems(list, (NodeImpl)attributes.item(index), deep);
            }
            NodeList children = node.getChildNodes();
            for (int index = 0; index < children.getLength(); ++index) {
                this.listModelItems(list, (NodeImpl)children.item(index), deep);
            }
        }
    }

    private String toString(Node node) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DOMUtil.prettyPrintDOM(node, stream);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return System.getProperty("line.separator") + stream;
    }
}

