/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.core;

import org.apache.log4j.Logger;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;

public class UpdateHandler {
    private static Logger LOGGER = Logger.getLogger(UpdateHandler.class);
    private Model model;
    private boolean rebuild;
    private boolean recalculate;
    private boolean revalidate;
    private boolean refresh;

    public UpdateHandler(Model model) {
        this.model = model;
        this.rebuild = false;
        this.recalculate = false;
        this.revalidate = false;
        this.refresh = false;
    }

    public void doRebuild(boolean rebuild) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)((rebuild ? "deferring" : "clearing") + " rebuild"));
        }
        this.rebuild = rebuild;
    }

    public void doRecalculate(boolean recalculate) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)((recalculate ? "deferring" : "clearing") + " recalculate"));
        }
        this.recalculate = recalculate;
    }

    public void doRevalidate(boolean revalidate) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)((revalidate ? "deferring" : "clearing") + " revalidate"));
        }
        this.revalidate = revalidate;
    }

    public void doRefresh(boolean refresh) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)((refresh ? "deferring" : "clearing") + " refresh"));
        }
        this.refresh = refresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate() throws XFormsException {
        try {
            if (this.rebuild) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"performing deferred rebuild");
                }
                this.model.getContainer().dispatch(this.model.getTarget(), "xforms-rebuild", null);
            }
            if (this.recalculate) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"performing deferred recalculate");
                }
                this.model.getContainer().dispatch(this.model.getTarget(), "xforms-recalculate", null);
            }
            if (this.revalidate) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"performing deferred revalidate");
                }
                this.model.getContainer().dispatch(this.model.getTarget(), "xforms-revalidate", null);
            }
            if (this.refresh) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"performing deferred refresh");
                }
                this.model.getContainer().dispatch(this.model.getTarget(), "xforms-refresh", null);
            }
        }
        finally {
            this.rebuild = false;
            this.recalculate = false;
            this.revalidate = false;
            this.refresh = false;
        }
    }
}

