/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.core;

import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.xs.XSTypeDefinition;
import org.chiba.xml.ns.NamespaceResolver;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.core.ValidatorMode;
import org.chiba.xml.xforms.core.impl.DefaultValidatorMode;
import org.chiba.xml.xforms.core.impl.OptimizedValidatorMode;

public class Validator {
    private static Logger LOGGER = Logger.getLogger(Validator.class);
    private static String TYPE_STRING = "string";
    private static String TYPE_NS_STRING = NamespaceResolver.expand("http://www.w3.org/2001/XMLSchema", TYPE_STRING);
    private static String TYPE_DURATION = "duration";
    private static String TYPE_NS_DURATION = NamespaceResolver.expand("http://www.w3.org/2001/XMLSchema", TYPE_DURATION);
    private static String TYPE_ENTITY = "ENTITY";
    private static String TYPE_NS_ENTITY = NamespaceResolver.expand("http://www.w3.org/2001/XMLSchema", TYPE_ENTITY);
    private static String TYPE_ENTITIES = "ENTITIES";
    private static String TYPE_NS_ENTITIES = NamespaceResolver.expand("http://www.w3.org/2001/XMLSchema", TYPE_ENTITIES);
    private static String TYPE_NOTATION = "NOTATION";
    private static String TYPE_NS_NOTATION = NamespaceResolver.expand("http://www.w3.org/2001/XMLSchema", TYPE_NOTATION);
    private Model model;
    private Map datatypes;
    private ValidatorMode mode = new OptimizedValidatorMode();

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Map getDatatypes() {
        return this.datatypes;
    }

    public void setDatatypes(Map datatypes) {
        this.datatypes = datatypes;
    }

    public boolean isKnown(String name) {
        if (this.datatypes == null) {
            return false;
        }
        String expandedName = NamespaceResolver.getExpandedName(this.model.getElement(), name);
        return this.datatypes.get(expandedName) != null;
    }

    public boolean isSupported(String name) {
        String expandedName = NamespaceResolver.getExpandedName(this.model.getElement(), name);
        return !TYPE_DURATION.equals(expandedName) && !TYPE_NS_DURATION.equals(expandedName) && !TYPE_ENTITY.equals(expandedName) && !TYPE_NS_ENTITY.equals(expandedName) && !TYPE_ENTITIES.equals(expandedName) && !TYPE_NS_ENTITIES.equals(expandedName) && !TYPE_NOTATION.equals(expandedName) && !TYPE_NS_NOTATION.equals(expandedName);
    }

    public boolean isRestricted(String base, String restriction) {
        if (this.datatypes == null) {
            return false;
        }
        String baseName = NamespaceResolver.getExpandedName(this.model.getElement(), base);
        XSSimpleType baseType = (XSSimpleType)this.datatypes.get(baseName);
        if (baseType == null) {
            return false;
        }
        String restrictionName = NamespaceResolver.getExpandedName(this.model.getElement(), restriction);
        XSSimpleType restrictionType = (XSSimpleType)this.datatypes.get(restrictionName);
        if (restrictionType == null) {
            return false;
        }
        return restrictionType.derivedFromType((XSTypeDefinition)baseType, (short)2);
    }

    public void validate(Instance instance) {
        this.validate(instance, "/", this.model.isReady() ? this.mode : new DefaultValidatorMode());
    }

    public void validate(Instance instance, String path, ValidatorMode mode) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("validate: processing " + instance + " path '" + path + "' in " + mode + " mode"));
        }
        Iterator iterator = instance.iterateModelItems(path);
        while (iterator.hasNext()) {
            ModelItem modelItem = (ModelItem)iterator.next();
            if (mode.performValidation(modelItem)) {
                this.validate(modelItem);
            }
            if (mode.continueValidation(modelItem)) continue;
            return;
        }
    }

    public void validate(ModelItem modelItem) {
        String xfType;
        String value = modelItem.getValue();
        if (modelItem.isXSINillable() && (value == null || value.length() == 0)) {
            if (LOGGER.isDebugEnabled()) {
                String xsiPrefix = NamespaceResolver.getPrefix(this.model.getElement(), "http://www.w3.org/2001/XMLSchema-instance");
                LOGGER.debug((Object)("validate: item " + modelItem.getNode() + " with @" + xsiPrefix + ":nil='true' considered valid"));
            }
            modelItem.getLocalUpdateView().setDatatypeValid(true);
            return;
        }
        boolean datatypeValid = true;
        String xsiType = this.expandName(modelItem.getXSIType());
        if (xsiType != null && !this.isDefaultType(xsiType)) {
            datatypeValid = this.checkDatatype(xsiType, value);
        }
        if ((xfType = this.expandName(modelItem.getDeclarationView().getDatatype())) != null && !this.isDefaultType(xfType)) {
            datatypeValid &= this.checkDatatype(xfType, value);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("validate: item " + modelItem.getNode() + " computed " + (datatypeValid ? "valid" : "invalid")));
        }
        modelItem.getLocalUpdateView().setDatatypeValid(datatypeValid);
    }

    private String expandName(String datatype) {
        return datatype != null ? NamespaceResolver.getExpandedName(this.model.getElement(), datatype) : null;
    }

    private boolean isDefaultType(String expandedName) {
        return TYPE_STRING.equals(expandedName) || TYPE_NS_STRING.equals(expandedName);
    }

    private boolean checkDatatype(String expandedName, String value) {
        XSSimpleType simpleType = (XSSimpleType)this.datatypes.get(expandedName);
        ValidatedInfo validatedInfo = new ValidatedInfo();
        ValidationState validationState = new ValidationState();
        validationState.setFacetChecking(true);
        validationState.setExtraChecking(false);
        try {
            simpleType.validate(value, (ValidationContext)validationState, validatedInfo);
        }
        catch (InvalidDatatypeValueException e) {
            return false;
        }
        return true;
    }
}

