/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.core.impl;

import org.apache.log4j.Logger;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.core.ValidatorMode;

public class SubmissionValidatorMode
implements ValidatorMode {
    private static Logger LOGGER = Logger.getLogger(SubmissionValidatorMode.class);
    private boolean discontinued = false;

    public boolean isDiscontinued() {
        return this.discontinued;
    }

    public boolean performValidation(ModelItem modelItem) {
        if (!modelItem.isEnabled()) {
            return false;
        }
        if (!modelItem.getStateChangeView().hasValueChanged()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("validate: item " + modelItem.getNode() + " is unmodified: validation skipped"));
            }
            return false;
        }
        return true;
    }

    public boolean continueValidation(ModelItem modelItem) {
        if (!modelItem.isEnabled()) {
            return true;
        }
        if (!modelItem.isValid() || modelItem.isRequired() && modelItem.getValue().length() == 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("validate: item " + modelItem.getNode() + " is invalid or required but empty: validation stopped"));
            }
            this.discontinued = true;
            return false;
        }
        return true;
    }

    public String toString() {
        return "submission";
    }
}

