/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import org.apache.log4j.Logger;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.AbstractUIElement;
import org.chiba.xml.xforms.ui.Switch;
import org.chiba.xml.xforms.ui.state.UIElementStateUtil;
import org.w3c.dom.Element;

public class Case
extends AbstractUIElement {
    private static final Logger LOGGER = Logger.getLogger(Case.class);
    private boolean selected;
    private Element state;

    public Case(Element element, Model model) {
        super(element, model);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Switch getSwitch() {
        return (Switch)this.getParentObject();
    }

    public void select() throws XFormsException {
        this.selected = true;
        UIElementStateUtil.setStateAttribute(this.state, "selected", String.valueOf(this.selected));
        this.getSwitch().setSelected(this);
    }

    public void deselect() {
        this.selected = false;
        UIElementStateUtil.setStateAttribute(this.state, "selected", String.valueOf(this.selected));
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeCase();
        this.initializeChildren();
        this.initializeActions();
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeCase();
        this.disposeChildren();
        this.disposeSelf();
    }

    protected final void initializeCase() {
        this.state = UIElementStateUtil.createStateElement(this.element);
    }

    protected void updateChildren() throws XFormsException {
        if (this.isSelected()) {
            super.updateChildren();
        }
    }

    protected final void disposeCase() {
        this.element.removeChild(this.state);
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

