/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.core.BindingResolver;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsComputeException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.AbstractFormControl;
import org.chiba.xml.xforms.ui.UIElementState;
import org.chiba.xml.xforms.ui.state.OutputElementState;
import org.w3c.dom.Element;

public class Output
extends AbstractFormControl {
    private static final Logger LOGGER = Logger.getLogger(Output.class);

    public Output(Element element, Model model) {
        super(element, model);
    }

    public void setValue(String value) {
        this.getLogger().warn((Object)(this + " set value: the value of an output control cannot be set"));
    }

    public boolean hasValueAttribute() {
        return this.getXFormsAttribute("value") != null;
    }

    public String getValueAttribute() {
        return this.getXFormsAttribute("value");
    }

    public Object computeValueAttribute() throws XFormsException {
        double doubleValue;
        String pathExpression = BindingResolver.getExpressionPath(this, this.repeatItemId);
        Instance instance = this.model.getInstance(this.model.computeInstanceId(pathExpression));
        if (!instance.existsNode(pathExpression)) {
            return null;
        }
        String valueAttribute = this.getValueAttribute();
        JXPathContext context = instance.getInstanceContext();
        String currentPath = this.getParentContextPath(this.element);
        context.getVariables().declareVariable("currentContextPath", (Object)currentPath);
        try {
            context.getPointer(pathExpression + "[chiba:declare('output-value', " + valueAttribute + ")]");
        }
        catch (Exception e) {
            throw new XFormsComputeException("invalid value expression at " + this, e, this.target, valueAttribute);
        }
        Object value = context.getValue("chiba:undeclare('output-value')");
        context.getVariables().undeclareVariable("currentContextPath");
        if (value instanceof Double && !Double.isNaN(doubleValue = ((Double)value).doubleValue()) && !Double.isInfinite(doubleValue)) {
            value = context.getValue("string(" + value + ")");
        }
        return value;
    }

    protected UIElementState createElementState() throws XFormsException {
        if (this.isBound()) {
            return super.createElementState();
        }
        if (this.hasValueAttribute()) {
            return new OutputElementState();
        }
        return null;
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

