/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.NodeImpl;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.BoundElement;
import org.chiba.xml.xforms.ui.Case;
import org.chiba.xml.xforms.ui.UIElementState;
import org.chiba.xml.xforms.ui.state.BoundElementState;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Switch
extends BoundElement {
    private static final Logger LOGGER = Logger.getLogger(Switch.class);
    private Case selected = null;
    private boolean initAfterReady = false;

    public Switch(Element element, Model model) {
        super(element, model);
    }

    public Case getSelected() {
        return this.selected;
    }

    public void setSelected(Case selected) {
        this.selected = selected;
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.initializeElementState();
        this.initializeChildren();
        this.initializeSwitch();
    }

    public void update() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " update"));
        }
        this.updateElementState();
        this.updateChildren();
        this.updateSwitch();
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeChildren();
        this.disposeElementState();
        this.disposeSwitch();
        this.disposeSelf();
    }

    protected final void initializeSwitch() throws XFormsException {
        Case caseElement;
        int index;
        NodeList childNodes = this.getElement().getChildNodes();
        ArrayList<Case> cases = new ArrayList<Case>(childNodes.getLength());
        int selection = -1;
        for (index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1 || !"http://www.w3.org/2002/xforms".equals(node.getNamespaceURI()) || !"case".equals(node.getLocalName())) continue;
            caseElement = (Case)((NodeImpl)node).getUserData();
            cases.add(caseElement);
            String selectedAttribute = caseElement.getXFormsAttribute("selected");
            if (selection != -1 || !"true".equals(selectedAttribute)) continue;
            selection = cases.size() - 1;
        }
        if (selection == -1) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " init: choosing first case for selection by default"));
            }
            selection = 0;
        }
        for (index = 0; index < cases.size(); ++index) {
            caseElement = (Case)cases.get(index);
            if (index == selection) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(this + " init: selecting case '" + caseElement.getId() + "'"));
                }
                caseElement.select();
                continue;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " init: deselecting case '" + caseElement.getId() + "'"));
            }
            caseElement.deselect();
        }
        this.initAfterReady = this.model.isReady();
    }

    protected final void updateSwitch() throws XFormsException {
        if (this.initAfterReady) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("selected", this.selected.getId());
            this.container.dispatch(this.target, "chiba-switch-toggled", map);
            this.initAfterReady = false;
        }
    }

    protected final void disposeSwitch() {
        this.selected = null;
    }

    protected UIElementState createElementState() throws XFormsException {
        return this.isBound() ? new BoundElementState(false, false) : null;
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

