/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.core.Validator;
import org.chiba.xml.xforms.exception.XFormsBindingException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.AbstractFormControl;
import org.chiba.xml.xforms.ui.Filename;
import org.chiba.xml.xforms.ui.Mediatype;
import org.w3c.dom.Element;

public class Upload
extends AbstractFormControl {
    private static final Logger LOGGER = Logger.getLogger(Upload.class);
    public static final String DEFAULT_MEDIATYPE = "application/octet-stream";
    private Filename filenameHelper;
    private Mediatype mediatypeHelper;

    public Upload(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.initializeElementState();
        this.initializeChildren();
        this.initializeUpload();
        this.initializeActions();
    }

    protected final void initializeUpload() throws XFormsException {
        if (this.isBound()) {
            Instance instance = this.model.getInstance(this.getInstanceId());
            ModelItem item = instance.getModelItem(this.getLocationPath());
            if (this.filenameHelper != null && !item.isReadonly()) {
                item.setFilename(this.filenameHelper.getValue());
            }
            if (this.mediatypeHelper != null && !item.isReadonly()) {
                item.setMediatype(this.mediatypeHelper.getValue());
            }
        }
    }

    public void setValue(String value) throws XFormsException {
        LOGGER.warn((Object)"Update control cannot be set with this method.");
    }

    public void setValue(byte[] data, String filename, String mediatype) throws XFormsException {
        String value;
        if (!this.isBound()) {
            return;
        }
        String name = filename;
        String type = mediatype;
        if (data != null && data.length > 0) {
            String datatype;
            Validator validator = this.model.getValidator();
            if (validator.isRestricted("base64Binary", datatype = this.getDatatype())) {
                value = new String(Base64.encodeBase64((byte[])data, (boolean)true));
            } else if (validator.isRestricted("hexBinary", datatype)) {
                value = new String(Hex.encodeHex((byte[])data));
            } else if (validator.isRestricted("anyURI", datatype)) {
                value = new String(data);
            } else {
                throw new XFormsBindingException("datatype not supported by upload control", this.target, (Object)datatype);
            }
            if (mediatype == null || mediatype.length() == 0) {
                type = DEFAULT_MEDIATYPE;
            }
        } else {
            value = "";
            name = "";
            type = "";
        }
        Instance instance = this.model.getInstance(this.getInstanceId());
        instance.setNodeValue(this.getLocationPath(), value);
        ModelItem item = instance.getModelItem(this.getLocationPath());
        if (!item.isReadonly()) {
            item.setFilename(name);
            item.setMediatype(type);
        }
        if (this.filenameHelper != null) {
            this.filenameHelper.setValue(name);
        }
        if (this.mediatypeHelper != null) {
            this.mediatypeHelper.setValue(type);
        }
        this.dispatchValueChangeSequence();
    }

    public Filename getFilename() {
        return this.filenameHelper;
    }

    public void setFilename(Filename filename) {
        this.filenameHelper = filename;
    }

    public Mediatype getMediatype() {
        return this.mediatypeHelper;
    }

    public void setMediatype(Mediatype mediatype) {
        this.mediatypeHelper = mediatype;
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

