/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui.state;

import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.BoundElement;
import org.chiba.xml.xforms.ui.Output;
import org.chiba.xml.xforms.ui.UIElementState;
import org.chiba.xml.xforms.ui.state.UIElementStateUtil;
import org.w3c.dom.Element;

public class OutputElementState
implements UIElementState {
    private Output owner;
    private Element state;
    private String currentValue;

    public void setOwner(BoundElement owner) {
        this.owner = (Output)owner;
    }

    public void init() throws XFormsException {
        Object valueObject;
        this.state = UIElementStateUtil.createStateElement(this.owner.getElement());
        String datatype = UIElementStateUtil.getDefaultDatatype(this.state);
        UIElementStateUtil.setStateAttribute(this.state, "type", datatype);
        if (!this.owner.getModel().isReady() && (valueObject = this.owner.computeValueAttribute()) != null) {
            String value = valueObject.toString();
            DOMUtil.setElementValue(this.state, value);
            this.currentValue = value;
        }
    }

    public void update() throws XFormsException {
        Object valueObject = this.owner.computeValueAttribute();
        String value = valueObject != null ? valueObject.toString() : null;
        DOMUtil.setElementValue(this.state, value);
        UIElementStateUtil.dispatchChibaEvents((BoundElement)this.owner, this.currentValue, value);
        this.currentValue = value;
    }

    public void dispose() throws XFormsException {
        this.state.getParentNode().removeChild(this.state);
        this.state = null;
        this.owner = null;
    }

    public String getValue() {
        return this.currentValue;
    }

    public void setProperty(String name, Object value) {
    }
}

