/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xpath.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jxpath.ri.Compiler;
import org.apache.commons.jxpath.ri.Parser;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.ExpressionPath;
import org.apache.commons.jxpath.ri.compiler.ExtensionFunction;
import org.apache.commons.jxpath.ri.compiler.LocationPath;
import org.apache.commons.jxpath.ri.compiler.Operation;
import org.apache.commons.jxpath.ri.compiler.Path;
import org.apache.commons.jxpath.ri.compiler.Step;
import org.apache.commons.jxpath.ri.compiler.TreeCompiler;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xpath.XPathReferenceFinder;

public class JXPathReferenceFinderImpl
implements XPathReferenceFinder {
    private Compiler compiler;

    public Set getReferences(String xpath) throws XFormsException {
        try {
            if (this.compiler == null) {
                this.compiler = new TreeCompiler();
            }
            Object expression = Parser.parseExpression((String)xpath, (Compiler)this.compiler);
            HashMap references = new HashMap();
            this.addExpressionReferences(references, null, (Expression)expression);
            return references.keySet();
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    private void addExpressionReferences(Map references, Expression context, Expression expression) {
        ExtensionFunction function;
        if (expression instanceof LocationPath) {
            LocationPath locationPath = (LocationPath)expression;
            Path path = this.addLocationPath(context, (LocationPath)expression);
            references.put(path.toString(), path);
            Expression contextExpression = context == null ? this.compiler.locationPath(locationPath.isAbsolute(), null) : context;
            this.addStepReferences(references, contextExpression, locationPath.getSteps());
            return;
        }
        if (expression instanceof ExpressionPath) {
            ExpressionPath expressionPath = (ExpressionPath)expression;
            references.put(expressionPath.toString(), expressionPath);
            Expression[] predicates = expressionPath.getPredicates();
            for (int i = 0; predicates != null && i < predicates.length; ++i) {
                this.addExpressionReferences(references, expressionPath.getExpression(), predicates[i]);
            }
            this.addStepReferences(references, expressionPath.getExpression(), expressionPath.getSteps());
            return;
        }
        if (expression instanceof ExtensionFunction && (function = (ExtensionFunction)expression).getFunctionName().getName().equals("instance")) {
            references.put(expression.toString(), expression);
            return;
        }
        if (expression instanceof Operation) {
            Operation operation = (Operation)expression;
            Expression[] arguments = operation.getArguments();
            for (int i = 0; arguments != null && i < arguments.length; ++i) {
                this.addExpressionReferences(references, context, arguments[i]);
            }
        }
    }

    private void addStepReferences(Map references, Expression context, Step[] steps) {
        for (int i = 0; steps != null && i < steps.length; ++i) {
            Step step = steps[i];
            Expression[] predicates = step.getPredicates();
            if (predicates == null || predicates.length <= 0) continue;
            Step tmp = step;
            steps[i] = (Step)this.compiler.step(step.getAxis(), (Object)step.getNodeTest(), null);
            Path path = this.addSteps(context, steps, i + 1);
            steps[i] = tmp;
            for (int j = 0; j < predicates.length; ++j) {
                this.addExpressionReferences(references, (Expression)path, predicates[j]);
            }
        }
    }

    private Path addLocationPath(Expression context, LocationPath path) {
        if (context == null || path.isAbsolute()) {
            return path;
        }
        Step[] steps = path.getSteps();
        return this.addSteps(context, steps, steps.length);
    }

    private Path addSteps(Expression context, Step[] steps, int length) {
        Path path;
        ArrayList<Step> stepList = new ArrayList<Step>();
        if (context instanceof Path && (path = (Path)context).getSteps() != null) {
            stepList.addAll(Arrays.asList(((Path)context).getSteps()));
        }
        for (int i = 0; i < length; ++i) {
            stepList.add(steps[i]);
        }
        Object[] stepArray = stepList.toArray(new Step[stepList.size()]);
        if (context instanceof LocationPath) {
            LocationPath locationPath = (LocationPath)context;
            return (Path)this.compiler.locationPath(locationPath.isAbsolute(), stepArray);
        }
        if (context instanceof ExpressionPath) {
            ExpressionPath expressionPath = (ExpressionPath)context;
            return (Path)this.compiler.expressionPath((Object)expressionPath.getExpression(), (Object[])expressionPath.getPredicates(), stepArray);
        }
        return (Path)this.compiler.expressionPath((Object)context, null, stepArray);
    }
}

