/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.web.app.ResourceBundleWrapper;
import org.alfresco.web.app.portlet.AlfrescoFacesPortlet;
import org.alfresco.web.app.servlet.AuthenticationHelper;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.ErrorBean;
import org.alfresco.web.bean.SidebarBean;
import org.alfresco.web.bean.dashboard.DashboardManager;
import org.alfresco.web.bean.dialog.DialogManager;
import org.alfresco.web.bean.repository.PreferencesService;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.bean.wizard.WizardManager;
import org.alfresco.web.config.ClientConfigElement;
import org.alfresco.web.config.LanguagesConfigElement;
import org.apache.commons.logging.Log;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.jsf.FacesContextUtils;

public class Application {
    private static final String LOCALE = "locale";
    public static final String BEAN_CONFIG_SERVICE = "webClientConfigService";
    public static final String BEAN_DATA_DICTIONARY = "dataDictionary";
    public static final String BEAN_IMPORTER_BOOTSTRAP = "spacesBootstrap";
    private static final String BEAN_UNPROTECTED_AUTH_SERVICE = "authenticationService";
    public static final String MESSAGE_BUNDLE = "alfresco.messages.webclient";
    private static ThreadLocal<Boolean> inPortalServer = new ThreadLocal();
    private static StoreRef repoStoreRef;
    private static String rootPath;
    private static String companyRootId;
    private static String glossaryFolderName;
    private static String spaceTemplatesFolderName;
    private static String contentTemplatesFolderName;
    private static String emailTemplatesFolderName;
    private static String inviteEmailTemplatesFolderName;
    private static String notifyEmailTemplatesFolderName;
    private static String rssTemplatesFolderName;
    private static String savedSearchesFolderName;
    private static String scriptsFolderName;
    private static String guestHomeFolderName;
    private static String websitesFolderName;
    private static String webContentFormsFolderName;
    private static String contentFormsFolderName;
    private static String projectsFolderName;
    private static Boolean isDynamicConfig;

    private Application() {
    }

    public static void setInPortalServer(boolean inPortal) {
        inPortalServer.set(inPortal ? Boolean.TRUE : null);
    }

    public static boolean inPortalServer() {
        Boolean result = inPortalServer.get();
        return result == null ? false : result;
    }

    public static void handleServletError(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Throwable error, Log logger, String returnPage) throws IOException, ServletException {
        HttpSession session = request.getSession();
        ErrorBean errorBean = (ErrorBean)session.getAttribute("alfresco.ErrorBean");
        if (errorBean == null) {
            errorBean = new ErrorBean();
            session.setAttribute("alfresco.ErrorBean", (Object)errorBean);
        }
        errorBean.setLastError(error);
        errorBean.setReturnPage(returnPage);
        boolean errorShown = false;
        String errorPage = Application.getErrorPage(servletContext);
        if (errorPage != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("An error has occurred, redirecting to error page: " + errorPage));
            }
            if (!response.isCommitted()) {
                errorShown = true;
                response.sendRedirect(request.getContextPath() + errorPage);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"Response is already committed, re-throwing error");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"No error page defined, re-throwing error");
        }
        if (!errorShown) {
            if (error instanceof IOException) {
                throw (IOException)error;
            }
            if (error instanceof ServletException) {
                throw (ServletException)error;
            }
            throw new ServletException(error);
        }
    }

    public static void handleSystemError(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String messageKey, int statusCode, Log logger) throws IOException, ServletException {
        HttpSession session = request.getSession();
        ErrorBean errorBean = (ErrorBean)session.getAttribute("alfresco.ErrorBean");
        if (errorBean == null) {
            errorBean = new ErrorBean();
            session.setAttribute("alfresco.ErrorBean", (Object)errorBean);
        }
        errorBean.setErrorMessageKey(messageKey);
        errorBean.setReturnPage(null);
        boolean errorShown = false;
        String errorPage = Application.getErrorPage(servletContext);
        if (errorPage != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("An error has occurred, forwarding to error page: " + errorPage));
            }
            if (!response.isCommitted()) {
                errorShown = true;
                response.reset();
                response.setStatus(statusCode);
                response.setContentType("text/html");
                response.setCharacterEncoding("utf-8");
                servletContext.getRequestDispatcher(errorPage).include((ServletRequest)request, (ServletResponse)response);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"Response is already committed, re-throwing error");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"No error page defined, re-throwing error");
        }
        if (!errorShown) {
            throw new ServletException(Application.getMessage(session, messageKey));
        }
    }

    public static DialogManager getDialogManager() {
        return (DialogManager)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "DialogManager");
    }

    public static WizardManager getWizardManager() {
        return (WizardManager)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "WizardManager");
    }

    public static DashboardManager getDashboardManager() {
        return (DashboardManager)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "DashboardManager");
    }

    public static SidebarBean getSidebarBean() {
        return (SidebarBean)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "SidebarBean");
    }

    public static String getErrorPage(ServletContext servletContext) {
        return Application.getErrorPage((ApplicationContext)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext));
    }

    public static String getLoginPage(ServletContext servletContext) {
        return Application.getLoginPage((ApplicationContext)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext));
    }

    public static User getCurrentUser(HttpSession session) {
        return (User)session.getAttribute("_alfAuthTicket");
    }

    public static User getCurrentUser(FacesContext context) {
        User user;
        if (Application.inPortalServer() && (user = (User)AlfrescoFacesPortlet.getPortletSessionAttribute(context, "_alfAuthTicket", true)) != null) {
            return user;
        }
        return (User)context.getExternalContext().getSessionMap().get("_alfAuthTicket");
    }

    public static void setCurrentUser(FacesContext context, User user) {
        if (Application.inPortalServer()) {
            AlfrescoFacesPortlet.setPortletSessionAttribute(context, "_alfAuthTicket", user, true);
        } else {
            context.getExternalContext().getSessionMap().put("_alfAuthTicket", user);
        }
    }

    public static void logOut(FacesContext context) {
        String ticket = null;
        if (Application.inPortalServer()) {
            ticket = AlfrescoFacesPortlet.onLogOut(context.getExternalContext().getRequest());
        } else {
            Cookie authCookie;
            HttpServletRequest request;
            HttpSession session;
            User user = Application.getCurrentUser(context);
            if (user != null) {
                ticket = user.getTicket();
            }
            if ((session = (request = (HttpServletRequest)context.getExternalContext().getRequest()).getSession(false)) != null) {
                session.invalidate();
            }
            if ((authCookie = AuthenticationHelper.getAuthCookie(request)) != null) {
                HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
                if (response.isCommitted()) {
                    request.getSession().setAttribute("_alfSessionInvalid", (Object)true);
                } else {
                    authCookie.setMaxAge(0);
                    response.addCookie(authCookie);
                }
            }
        }
        WebApplicationContext wc = FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context);
        AuthenticationService unprotAuthService = (AuthenticationService)wc.getBean(BEAN_UNPROTECTED_AUTH_SERVICE);
        if (ticket != null) {
            unprotAuthService.invalidateTicket(ticket);
        }
        unprotAuthService.clearCurrentSecurityContext();
    }

    public static StoreRef getRepositoryStoreRef(ServletContext context) {
        return Application.getRepositoryStoreRef(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static StoreRef getRepositoryStoreRef(FacesContext context) {
        return Application.getRepositoryStoreRef(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getCompanyRootId() {
        return companyRootId;
    }

    public static void setCompanyRootId(String id) {
        companyRootId = id;
    }

    public static String getCompanyRootId(FacesContext context) {
        User user = Application.getCurrentUser(context);
        if (user != null) {
            String userCompanyRootId = user.getCompanyRootId();
            if (userCompanyRootId == null) {
                userCompanyRootId = Repository.getCompanyRoot(context).getId();
                user.setCompanyRootId(userCompanyRootId);
            }
            return userCompanyRootId;
        }
        return null;
    }

    public static String getRootPath(ServletContext context) {
        return Application.getRootPath(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getRootPath(FacesContext context) {
        return Application.getRootPath(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getGlossaryFolderName(ServletContext context) {
        return Application.getGlossaryFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getGlossaryFolderName(FacesContext context) {
        return Application.getGlossaryFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getSpaceTemplatesFolderName(ServletContext context) {
        return Application.getSpaceTemplatesFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getSpaceTemplatesFolderName(FacesContext context) {
        return Application.getSpaceTemplatesFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getContentTemplatesFolderName(ServletContext context) {
        return Application.getContentTemplatesFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getContentTemplatesFolderName(FacesContext context) {
        return Application.getContentTemplatesFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getInviteEmailTemplatesFolderName(ServletContext context) {
        return Application.getInviteEmailTemplatesFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getInviteEmailTemplatesFolderName(FacesContext context) {
        return Application.getInviteEmailTemplatesFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getNotifyEmailTemplatesFolderName(ServletContext context) {
        return Application.getNotifyEmailTemplatesFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getNotifyEmailTemplatesFolderName(FacesContext context) {
        return Application.getNotifyEmailTemplatesFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getEmailTemplatesFolderName(ServletContext context) {
        return Application.getEmailTemplatesFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getEmailTemplatesFolderName(FacesContext context) {
        return Application.getEmailTemplatesFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getRSSTemplatesFolderName(ServletContext context) {
        return Application.getRSSTemplatesFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getRSSTemplatesFolderName(FacesContext context) {
        return Application.getRSSTemplatesFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getSavedSearchesFolderName(ServletContext context) {
        return Application.getSavedSearchesFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getSavedSearchesFolderName(FacesContext context) {
        return Application.getSavedSearchesFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getScriptsFolderName(ServletContext context) {
        return Application.getScriptsFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getScriptsFolderName(FacesContext context) {
        return Application.getScriptsFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getGuestHomeFolderName(ServletContext context) {
        return Application.getGuestHomeFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getGuestHomeFolderName(FacesContext context) {
        return Application.getGuestHomeFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getWebsitesFolderName(ServletContext context) {
        return Application.getWebsitesFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getWebsitesFolderName(FacesContext context) {
        return Application.getWebsitesFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getWebContentFormsFolderName(ServletContext context) {
        return Application.getWebContentFormsFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getWebContentFormsFolderName(FacesContext context) {
        return Application.getWebContentFormsFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getContentFormsFolderName(ServletContext context) {
        return Application.getContentFormsFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getContentFormsFolderName(FacesContext context) {
        return Application.getContentFormsFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static String getProjectsFolderName(ServletContext context) {
        return Application.getProjectsFolderName(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context));
    }

    public static String getProjectsFolderName(FacesContext context) {
        return Application.getProjectsFolderName(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context));
    }

    public static void setLanguage(FacesContext context, String code) {
        Locale locale = I18NUtil.parseLocale((String)code);
        context.getViewRoot().setLocale(locale);
        context.getExternalContext().getSessionMap().put(LOCALE, locale);
        context.getExternalContext().getSessionMap().remove(MESSAGE_BUNDLE);
        I18NUtil.setLocale((Locale)locale);
    }

    @Deprecated
    public static void setLanguage(HttpSession session, String code) {
        Locale locale = I18NUtil.parseLocale((String)code);
        session.setAttribute(LOCALE, (Object)locale);
        session.removeAttribute(MESSAGE_BUNDLE);
        I18NUtil.setLocale((Locale)locale);
    }

    public static Locale getLanguage(FacesContext fc) {
        Locale locale = (Locale)fc.getExternalContext().getSessionMap().get(LOCALE);
        if (locale == null) {
            Config config;
            LanguagesConfigElement langConfig;
            List<String> languages;
            String strLocale = null;
            locale = Application.getCurrentUser(fc) != null ? ((strLocale = (String)((Object)PreferencesService.getPreferences(fc).getValue("interface-language"))) != null ? I18NUtil.parseLocale((String)strLocale) : Locale.getDefault()) : ((languages = (langConfig = (LanguagesConfigElement)(config = Application.getConfigService(fc).getConfig((Object)"Languages")).getConfigElement("languages")).getLanguages()) != null && languages.size() != 0 ? I18NUtil.parseLocale((String)languages.get(0)) : Locale.getDefault());
            fc.getExternalContext().getSessionMap().put(LOCALE, locale);
        }
        return locale;
    }

    public static Locale getLanguage(HttpSession session) {
        Locale locale = (Locale)session.getAttribute(LOCALE);
        if (locale == null) {
            String strLocale = null;
            locale = Application.getCurrentUser(session) != null ? ((strLocale = (String)((Object)PreferencesService.getPreferences(session).getValue("interface-language"))) != null ? I18NUtil.parseLocale((String)strLocale) : Locale.getDefault()) : Application.getLanguage((ApplicationContext)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)session.getServletContext()));
            session.setAttribute(LOCALE, (Object)locale);
        }
        return locale;
    }

    public static Locale getLanguage(ApplicationContext ctx) {
        Config config = ((ConfigService)ctx.getBean(BEAN_CONFIG_SERVICE)).getConfig((Object)"Languages");
        LanguagesConfigElement langConfig = (LanguagesConfigElement)config.getConfigElement("languages");
        List<String> languages = langConfig.getLanguages();
        if (languages != null && languages.size() != 0) {
            return I18NUtil.parseLocale((String)languages.get(0));
        }
        return Locale.getDefault();
    }

    public static String getMessage(FacesContext context, String msg) {
        return Application.getBundle(context).getString(msg);
    }

    public static String getMessage(HttpSession session, String msg) {
        return Application.getBundle(session).getString(msg);
    }

    public static ResourceBundle getBundle(HttpSession session) {
        ResourceBundle bundle = (ResourceBundle)session.getAttribute(MESSAGE_BUNDLE);
        if (bundle == null) {
            Locale locale = (Locale)session.getAttribute(LOCALE);
            if (locale == null) {
                locale = Locale.getDefault();
            }
            bundle = ResourceBundleWrapper.getResourceBundle(MESSAGE_BUNDLE, locale);
            session.setAttribute(MESSAGE_BUNDLE, (Object)bundle);
        }
        return bundle;
    }

    public static ResourceBundle getBundle(FacesContext context) {
        Map session = context.getExternalContext().getSessionMap();
        ResourceBundle bundle = (ResourceBundle)session.get(MESSAGE_BUNDLE);
        if (bundle == null) {
            Locale locale = (Locale)session.get(LOCALE);
            if (locale == null) {
                locale = Locale.getDefault();
            }
            bundle = ResourceBundleWrapper.getResourceBundle(MESSAGE_BUNDLE, locale);
            session.put(MESSAGE_BUNDLE, bundle);
        }
        return bundle;
    }

    public static ConfigService getConfigService(FacesContext context) {
        return (ConfigService)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean(BEAN_CONFIG_SERVICE);
    }

    public static ConfigService getConfigService(ServletContext context) {
        return (ConfigService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context).getBean(BEAN_CONFIG_SERVICE);
    }

    public static ClientConfigElement getClientConfig(FacesContext context) {
        return (ClientConfigElement)Application.getConfigService(context).getGlobalConfig().getConfigElement("client");
    }

    public static ClientConfigElement getClientConfig(ServletContext context) {
        return (ClientConfigElement)Application.getConfigService(context).getGlobalConfig().getConfigElement("client");
    }

    private static StoreRef getRepositoryStoreRef(WebApplicationContext context) {
        if (repoStoreRef == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            repoStoreRef = bootstrap.getStoreRef();
        }
        return repoStoreRef;
    }

    private static String getRootPath(WebApplicationContext context) {
        if (rootPath == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            rootPath = configuration.getProperty("spaces.company_home.childname");
        }
        return rootPath;
    }

    private static String getGlossaryFolderName(WebApplicationContext context) {
        if (glossaryFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            glossaryFolderName = configuration.getProperty("spaces.dictionary.childname");
        }
        return glossaryFolderName;
    }

    private static String getSpaceTemplatesFolderName(WebApplicationContext context) {
        if (spaceTemplatesFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            spaceTemplatesFolderName = configuration.getProperty("spaces.templates.childname");
        }
        return spaceTemplatesFolderName;
    }

    private static String getContentTemplatesFolderName(WebApplicationContext context) {
        if (contentTemplatesFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            contentTemplatesFolderName = configuration.getProperty("spaces.templates.content.childname");
        }
        return contentTemplatesFolderName;
    }

    private static String getEmailTemplatesFolderName(WebApplicationContext context) {
        if (emailTemplatesFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            emailTemplatesFolderName = configuration.getProperty("spaces.templates.email.childname");
        }
        return emailTemplatesFolderName;
    }

    private static String getInviteEmailTemplatesFolderName(WebApplicationContext context) {
        if (inviteEmailTemplatesFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            inviteEmailTemplatesFolderName = configuration.getProperty("spaces.templates.email.invite1.childname");
        }
        return inviteEmailTemplatesFolderName;
    }

    private static String getNotifyEmailTemplatesFolderName(WebApplicationContext context) {
        if (notifyEmailTemplatesFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            notifyEmailTemplatesFolderName = configuration.getProperty("spaces.templates.email.notify.childname");
        }
        return notifyEmailTemplatesFolderName;
    }

    private static String getRSSTemplatesFolderName(WebApplicationContext context) {
        if (rssTemplatesFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            rssTemplatesFolderName = configuration.getProperty("spaces.templates.rss.childname");
        }
        return rssTemplatesFolderName;
    }

    private static String getSavedSearchesFolderName(WebApplicationContext context) {
        if (savedSearchesFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            savedSearchesFolderName = configuration.getProperty("spaces.savedsearches.childname");
        }
        return savedSearchesFolderName;
    }

    private static String getScriptsFolderName(WebApplicationContext context) {
        if (scriptsFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            scriptsFolderName = configuration.getProperty("spaces.scripts.childname");
        }
        return scriptsFolderName;
    }

    private static String getGuestHomeFolderName(WebApplicationContext context) {
        if (guestHomeFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            guestHomeFolderName = configuration.getProperty("spaces.guest_home.childname");
        }
        return guestHomeFolderName;
    }

    private static String getWebsitesFolderName(WebApplicationContext context) {
        if (websitesFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            websitesFolderName = configuration.getProperty("spaces.wcm.childname");
        }
        return websitesFolderName;
    }

    private static String getProjectsFolderName(WebApplicationContext context) {
        if (projectsFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            projectsFolderName = configuration.getProperty("spaces.projects.childname");
        }
        return projectsFolderName;
    }

    private static String getWebContentFormsFolderName(WebApplicationContext context) {
        if (webContentFormsFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            webContentFormsFolderName = configuration.getProperty("spaces.wcm_content_forms.childname");
        }
        return webContentFormsFolderName;
    }

    private static String getContentFormsFolderName(WebApplicationContext context) {
        if (contentFormsFolderName == null) {
            ImporterBootstrap bootstrap = (ImporterBootstrap)context.getBean(BEAN_IMPORTER_BOOTSTRAP);
            Properties configuration = bootstrap.getConfiguration();
            contentFormsFolderName = configuration.getProperty("spaces.content_forms.childname");
        }
        return contentFormsFolderName;
    }

    public static String getErrorPage(ApplicationContext context) {
        String errorPage = null;
        ConfigService svc = (ConfigService)context.getBean(BEAN_CONFIG_SERVICE);
        ClientConfigElement clientConfig = (ClientConfigElement)svc.getGlobalConfig().getConfigElement("client");
        if (clientConfig != null) {
            errorPage = clientConfig.getErrorPage();
        }
        return errorPage;
    }

    public static String getLoginPage(ApplicationContext context) {
        String loginPage = null;
        ConfigService svc = (ConfigService)context.getBean(BEAN_CONFIG_SERVICE);
        ClientConfigElement clientConfig = (ClientConfigElement)svc.getGlobalConfig().getConfigElement("client");
        if (clientConfig != null) {
            loginPage = clientConfig.getLoginPage();
        }
        return loginPage;
    }

    public static boolean isDynamicConfig(FacesContext context) {
        if (isDynamicConfig == null) {
            String dynamicConfigParam = FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getServletContext().getInitParameter("org.alfresco.webclient.dynamicConfig");
            isDynamicConfig = new Boolean(dynamicConfigParam == null || new Boolean(dynamicConfigParam) == true);
        }
        return isDynamicConfig;
    }

    static {
        isDynamicConfig = null;
    }
}

