/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.InternalEhCacheManagerFactoryBean;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ContextListener
implements ServletContextListener,
HttpSessionListener {
    private static Log logger = LogFactory.getLog(ContextListener.class);
    private ServletContext servletContext;

    public void contextInitialized(ServletContextEvent event) {
        this.servletContext = event.getServletContext();
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        if (ctx == null) {
            return;
        }
        ServiceRegistry registry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        TransactionService transactionService = registry.getTransactionService();
        NodeService nodeService = registry.getNodeService();
        SearchService searchService = registry.getSearchService();
        NamespaceService namespaceService = registry.getNamespaceService();
        AuthenticationContext authenticationContext = (AuthenticationContext)ctx.getBean("authenticationContext");
        UserTransaction tx = null;
        NodeRef companySpaceNodeRef = null;
        try {
            tx = transactionService.getUserTransaction();
            tx.begin();
            authenticationContext.setSystemUserAsCurrentUser();
            StoreRef storeRef = Repository.getStoreRef(this.servletContext);
            String rootPath = Application.getRootPath(this.servletContext);
            companySpaceNodeRef = Repository.getCompanyRoot(nodeService, searchService, namespaceService, storeRef, rootPath);
            Application.setCompanyRootId(companySpaceNodeRef.getId());
            tx.commit();
        }
        catch (Throwable e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            logger.error((Object)"Failed to initialise ", e);
            throw new AlfrescoRuntimeException("Failed to initialise ", e);
        }
        finally {
            try {
                authenticationContext.clearCurrentSecurityContext();
            }
            catch (Exception ex) {}
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        InternalEhCacheManagerFactoryBean.getInstance().shutdown();
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("HTTP session created: " + event.getSession().getId()));
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("HTTP session destroyed: " + event.getSession().getId()));
        }
    }
}

