/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.web.app.servlet.BaseServlet;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTemplateContentServlet
extends BaseServlet {
    private static final String MIMETYPE_HTML = "text/html;charset=utf-8";
    private static final long serialVersionUID = -4123407921997235977L;
    private static final String ARG_MIMETYPE = "mimetype";
    private static final String ARG_TEMPLATE_PATH = "templatePath";
    private static final String ARG_CONTEXT_PATH = "contextPath";
    protected TemplateImageResolver imageResolver = new TemplateImageResolver(){

        public String resolveImagePathForName(String filename, FileTypeImageSize size) {
            return FileTypeImageUtils.getFileTypeImage((ServletContext)BaseTemplateContentServlet.this.getServletContext(), (String)filename, (FileTypeImageSize)size);
        }
    };

    protected abstract Log getLogger();

    protected abstract Map<String, Object> buildModel(ServiceRegistry var1, HttpServletRequest var2, NodeRef var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTemplateRequest(HttpServletRequest req, HttpServletResponse res, boolean redirectToLogin) throws ServletException, IOException {
        block40: {
            Log logger = this.getLogger();
            String uri = req.getRequestURI();
            if (logger.isDebugEnabled()) {
                String queryString = req.getQueryString();
                logger.debug((Object)("Processing URL: " + uri + (queryString != null && queryString.length() > 0 ? "?" + queryString : "")));
            }
            uri = uri.substring(req.getContextPath().length());
            StringTokenizer t = new StringTokenizer(uri, "/");
            int tokenCount = t.countTokens();
            t.nextToken();
            NodeRef nodeRef = null;
            NodeRef templateRef = null;
            try {
                String contentPath = req.getParameter(ARG_CONTEXT_PATH);
                if (contentPath != null && contentPath.length() != 0) {
                    BaseServlet.PathRefInfo pathInfo = BaseTemplateContentServlet.resolveNamePath(this.getServletContext(), contentPath);
                    nodeRef = pathInfo.NodeRef;
                } else if (tokenCount > 3) {
                    StoreRef storeRef = new StoreRef(t.nextToken(), t.nextToken());
                    nodeRef = new NodeRef(storeRef, t.nextToken());
                }
                String templatePath = req.getParameter(ARG_TEMPLATE_PATH);
                if (templatePath != null && templatePath.length() != 0) {
                    BaseServlet.PathRefInfo pathInfo = BaseTemplateContentServlet.resolveNamePath(this.getServletContext(), templatePath);
                    templateRef = pathInfo.NodeRef;
                } else if (tokenCount >= 7) {
                    StoreRef storeRef = new StoreRef(t.nextToken(), t.nextToken());
                    templateRef = new NodeRef(storeRef, t.nextToken());
                }
            }
            catch (AccessDeniedException err) {
                if (redirectToLogin) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Redirecting to login page...");
                    }
                    BaseTemplateContentServlet.redirectToLoginPage(req, res, this.getServletContext());
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Returning 403 Forbidden error...");
                    }
                    res.sendError(403);
                }
                return;
            }
            if (nodeRef == null && templateRef != null) {
                nodeRef = templateRef;
            }
            if (nodeRef == null) {
                throw new TemplateException("Not enough elements supplied in URL or no 'path' argument specified.");
            }
            ServiceRegistry serviceRegistry = BaseTemplateContentServlet.getServiceRegistry(this.getServletContext());
            NodeService nodeService = serviceRegistry.getNodeService();
            TemplateService templateService = serviceRegistry.getTemplateService();
            PermissionService permissionService = serviceRegistry.getPermissionService();
            if (permissionService.hasPermission(nodeRef, "Read") == AccessStatus.DENIED || templateRef != null && permissionService.hasPermission(templateRef, "Read") == AccessStatus.DENIED) {
                if (redirectToLogin) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Redirecting to login page...");
                    }
                    BaseTemplateContentServlet.redirectToLoginPage(req, res, this.getServletContext());
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Returning 403 Forbidden error...");
                    }
                    res.sendError(403);
                }
                return;
            }
            String mimetype = MIMETYPE_HTML;
            if (req.getParameter(ARG_MIMETYPE) != null) {
                mimetype = req.getParameter(ARG_MIMETYPE);
            }
            res.setContentType(mimetype);
            try {
                UserTransaction txn = null;
                try {
                    txn = serviceRegistry.getTransactionService().getUserTransaction(true);
                    txn.begin();
                    if (templateRef == null) {
                        if (nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TEMPLATABLE)) {
                            templateRef = (NodeRef)nodeService.getProperty(nodeRef, ContentModel.PROP_TEMPLATE);
                        }
                        if (templateRef == null) {
                            throw new TemplateException("Template reference not set against node or not supplied in URL.");
                        }
                    }
                    Map<String, Object> model = this.getModel(serviceRegistry, req, templateRef, nodeRef);
                    try {
                        templateService.processTemplate(templateRef.toString(), model, (Writer)res.getWriter());
                        txn.commit();
                    }
                    catch (SocketException e) {
                        if (e.getMessage().contains("ClientAbortException")) {
                            logger.error((Object)("Client aborted stream read:\n   node: " + nodeRef + "\n   template: " + templateRef));
                            try {
                                if (txn != null) {
                                    txn.rollback();
                                }
                                break block40;
                            }
                            catch (Exception tex) {}
                            break block40;
                        }
                        throw e;
                    }
                    finally {
                        res.getWriter().close();
                    }
                }
                catch (Throwable txnErr) {
                    try {
                        if (txn != null) {
                            txn.rollback();
                        }
                    }
                    catch (Exception tex) {
                        // empty catch block
                    }
                    throw txnErr;
                }
            }
            catch (Throwable err) {
                throw new AlfrescoRuntimeException("Error during template servlet processing: " + err.getMessage(), err);
            }
        }
    }

    private Map<String, Object> getModel(ServiceRegistry services, HttpServletRequest req, NodeRef templateRef, NodeRef nodeRef) {
        Map<String, Object> root = this.buildModel(services, req, templateRef);
        root.put("space", nodeRef);
        root.put("document", nodeRef);
        HashMap<String, String> args = new HashMap<String, String>(8, 1.0f);
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            try {
                args.put(name, new String(req.getParameter(name).getBytes(), "UTF-8"));
            }
            catch (UnsupportedEncodingException err) {}
        }
        root.put("args", args);
        root.put("imageresolver", this.imageResolver);
        root.put("url", new URLHelper(req));
        return root;
    }

    public static class URLHelper {
        String contextPath;
        String serverPath;

        public URLHelper(HttpServletRequest request) {
            this.contextPath = request.getContextPath();
            this.serverPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
        }

        public URLHelper(FacesContext context) {
            this.contextPath = context.getExternalContext().getRequestContextPath();
            Object request = context.getExternalContext().getRequest();
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                this.serverPath = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort();
            }
        }

        public String getContext() {
            return this.contextPath;
        }

        public String getServerPath() {
            return this.serverPath;
        }
    }
}

