/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.el.EvaluationException;
import javax.faces.el.ValueBinding;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.bean.generator.IComponentGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FacesHelper {
    public static final String BROWSE_VIEW_ID = "/jsp/browse/browse.jsp";
    private static Log logger = LogFactory.getLog(FacesHelper.class);
    private static final int MASK = 15;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private FacesHelper() {
    }

    public static FacesContext getFacesContext(ServletRequest request, ServletResponse response, ServletContext context) {
        return FacesHelper.getFacesContextImpl(request, response, context, null);
    }

    public static FacesContext getFacesContext(ServletRequest request, ServletResponse response, ServletContext context, String viewRoot) {
        return FacesHelper.getFacesContextImpl(request, response, context, viewRoot);
    }

    public static FacesContext getFacesContext(Object request, Object response, Object context) {
        return FacesHelper.getFacesContextImpl(request, response, context, null);
    }

    private static FacesContext getFacesContextImpl(Object request, Object response, Object context, String viewRoot) {
        FacesContextFactory contextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        FacesContext facesContext = contextFactory.getFacesContext(context, request, response, lifecycle);
        InnerFacesContext.setFacesContextAsCurrent(facesContext);
        if (viewRoot == null) {
            viewRoot = BROWSE_VIEW_ID;
        }
        UIViewRoot view = facesContext.getApplication().getViewHandler().createView(facesContext, viewRoot);
        facesContext.setViewRoot(view);
        return facesContext;
    }

    public static Object getManagedBean(FacesContext fc, String name) {
        Object obj = null;
        try {
            ValueBinding vb = fc.getApplication().createValueBinding("#{" + name + "}");
            obj = vb.getValue(fc);
        }
        catch (EvaluationException ee) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to resolve managed bean: " + name), (Throwable)ee);
            }
            obj = null;
        }
        return obj;
    }

    public static void setupComponentId(FacesContext context, UIComponent component, String id) {
        id = id == null ? context.getViewRoot().createUniqueId() : FacesHelper.makeLegalId(id);
        component.setId(id);
    }

    public static String makeLegalId(String id) {
        return id != null ? FacesHelper.validFacesId(id) : null;
    }

    public static IComponentGenerator getComponentGenerator(FacesContext context, String generatorName) {
        IComponentGenerator generator = FacesHelper.lookupComponentGenerator(context, generatorName);
        if (generator == null) {
            logger.warn((Object)"Attempting to find default component generator 'TextFieldGenerator'");
            generator = FacesHelper.lookupComponentGenerator(context, "TextFieldGenerator");
        }
        if (generator == null) {
            throw new AlfrescoRuntimeException("Failed to find a component generator, please ensure the 'TextFieldGenerator' bean is present in your configuration");
        }
        return generator;
    }

    private static IComponentGenerator lookupComponentGenerator(FacesContext context, String generatorName) {
        IComponentGenerator generator = null;
        Object obj = FacesHelper.getManagedBean(context, generatorName);
        if (obj != null) {
            if (obj instanceof IComponentGenerator) {
                generator = (IComponentGenerator)obj;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found component generator for '" + generatorName + "': " + generator));
                }
            } else {
                logger.warn((Object)("Bean '" + generatorName + "' does not implement IComponentGenerator"));
            }
        } else {
            logger.warn((Object)("Failed to find component generator with name of '" + generatorName + "'"));
        }
        return generator;
    }

    private static String validFacesId(String id) {
        int len = id.length();
        StringBuilder buf = new StringBuilder(len + (len >> 1));
        for (int i = 0; i < len; ++i) {
            char c;
            char ci = c = id.charAt(i);
            if (i == 0) {
                if (ci >= 'A' && ci <= 'Z' || ci >= 'a' && ci <= 'z') {
                    buf.append(c);
                    continue;
                }
                FacesHelper.encode(c, buf);
                continue;
            }
            if (ci >= 'A' && ci <= 'Z' || ci >= 'a' && ci <= 'z' || ci >= '0' && ci <= '9' || ci == '-' || ci == '_') {
                buf.append(c);
                continue;
            }
            FacesHelper.encode(c, buf);
        }
        return buf.toString();
    }

    private static void encode(char c, StringBuilder builder) {
        char[] buf = new char[]{'x', '0', '0', '0', '0', '_'};
        int charPos = 5;
        do {
            buf[--charPos] = DIGITS[c & 0xF];
        } while ((c = (char)(c >>> 4)) != '\u0000');
        builder.append(buf);
    }

    private static abstract class InnerFacesContext
    extends FacesContext {
        private InnerFacesContext() {
        }

        protected static void setFacesContextAsCurrent(FacesContext facesContext) {
            FacesContext.setCurrentInstance((FacesContext)facesContext);
        }
    }
}

