/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.TempFileProvider;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.alfresco.web.app.servlet.BaseServlet;
import org.alfresco.web.bean.ErrorBean;
import org.alfresco.web.bean.FileUploadBean;
import org.alfresco.web.config.ClientConfigElement;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UploadFileServlet
extends BaseServlet {
    private static final long serialVersionUID = -5482538466491052875L;
    private static final Log logger = LogFactory.getLog(UploadFileServlet.class);
    private ConfigService configService;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc.getServletContext());
        this.configService = (ConfigService)ctx.getBean("webClientConfigService");
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uploadId = null;
        String returnPage = null;
        ServletRequestContext requestContext = new ServletRequestContext(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)requestContext);
        try {
            AuthenticationStatus status = this.servletAuthenticate(request, response);
            if (status == AuthenticationStatus.Failure) {
                return;
            }
            if (!isMultipart) {
                throw new AlfrescoRuntimeException("This servlet can only be used to handle file upload requests, makesure you have set the enctype attribute on your form to multipart/form-data");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Uploading servlet servicing...");
            }
            FacesContext context = FacesContext.getCurrentInstance();
            Map session = context.getExternalContext().getSessionMap();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
            upload.setHeaderEncoding("UTF-8");
            List fileItems = upload.parseRequest(request);
            FileUploadBean bean = new FileUploadBean();
            for (FileItem item : fileItems) {
                if (item.isFormField()) {
                    if (item.getFieldName().equalsIgnoreCase("return-page")) {
                        returnPage = item.getString();
                        continue;
                    }
                    if (!item.getFieldName().equalsIgnoreCase("upload-id")) continue;
                    uploadId = item.getString();
                    continue;
                }
                String filename = item.getName();
                if (filename == null || filename.length() == 0) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Processing uploaded file: " + filename));
                }
                if (this.allowZeroByteFiles() || item.getSize() > 0L) {
                    filename = FilenameUtils.getName((String)filename);
                    File tempFile = TempFileProvider.createTempFile((String)"alfresco", (String)".upload");
                    item.write(tempFile);
                    bean.setFile(tempFile);
                    bean.setFileName(filename);
                    bean.setFilePath(tempFile.getAbsolutePath());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Temp file: " + tempFile.getAbsolutePath() + " size " + tempFile.length() + " bytes created from upload filename: " + filename));
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn((Object)("Ignored file '" + filename + "' as there was no content, this is either " + "caused by uploading an empty file or a file path that does not exist on the client."));
            }
            session.put(FileUploadBean.getKey(uploadId), bean);
            if (bean.getFile() == null && uploadId != null && logger.isWarnEnabled()) {
                logger.warn((Object)("no file uploaded for upload id: " + uploadId));
            }
            if (returnPage == null || returnPage.length() == 0) {
                throw new AlfrescoRuntimeException("return-page parameter has not been supplied");
            }
            if (returnPage.startsWith("javascript:")) {
                returnPage = returnPage.substring("javascript:".length());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending back javascript response " + returnPage));
                }
                response.setContentType("text/html");
                response.setCharacterEncoding("utf-8");
                response.setHeader("X-XSS-Protection", "0");
                PrintWriter out = response.getWriter();
                out.println("<html><body><script type=\"text/javascript\">");
                out.println(returnPage);
                out.println("</script></body></html>");
                out.close();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("redirecting to: " + returnPage));
                }
                response.sendRedirect(returnPage);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"upload complete");
            }
        }
        catch (Throwable error) {
            this.handleUploadException(request, response, error, returnPage);
        }
    }

    private void handleUploadException(HttpServletRequest request, HttpServletResponse response, Throwable error, String returnPage) {
        try {
            HttpSession session = request.getSession(true);
            ErrorBean errorBean = (ErrorBean)session.getAttribute("alfresco.ErrorBean");
            if (errorBean == null) {
                errorBean = new ErrorBean();
                session.setAttribute("alfresco.ErrorBean", (Object)errorBean);
            }
            errorBean.setLastError(error);
            errorBean.setReturnPage(returnPage);
        }
        catch (Throwable e) {
            logger.error((Object)"Error while handling upload Exception", e);
        }
        try {
            String errorPage = Application.getErrorPage(this.getServletContext());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("An error has occurred. Sending back response for redirecting to error page: " + errorPage));
            }
            response.setContentType("text/html");
            response.setCharacterEncoding("utf-8");
            PrintWriter out = response.getWriter();
            out.println("<html><body><script type=\"text/javascript\">");
            out.println("window.parent.location.replace(\" " + request.getContextPath() + errorPage + "\")");
            out.println("</script></body></html> ");
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while handling upload Exception", (Throwable)e);
        }
    }

    private boolean allowZeroByteFiles() {
        ClientConfigElement clientConfig = (ClientConfigElement)this.configService.getGlobalConfig().getConfigElement("client");
        return clientConfig.isZeroByteFileUploads();
    }
}

