/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.command;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.command.Command;
import org.alfresco.web.bean.repository.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecuteScriptCommand
implements Command {
    public static final String PROP_SCRIPT = "script";
    public static final String PROP_DOCUMENT = "document";
    public static final String PROP_USERPERSON = "person";
    public static final String PROP_ARGS = "args";
    private static final String[] PROPERTIES = new String[]{"script", "document", "person", "args"};

    @Override
    public String[] getPropertyNames() {
        return PROPERTIES;
    }

    @Override
    public Object execute(ServiceRegistry serviceRegistry, Map<String, Object> properties) {
        NodeRef scriptRef = (NodeRef)properties.get(PROP_SCRIPT);
        if (scriptRef == null) {
            throw new IllegalArgumentException("Unable to execute ExecuteScriptCommand - mandatory parameter not supplied: script");
        }
        NodeRef personRef = (NodeRef)properties.get(PROP_USERPERSON);
        if (personRef == null) {
            throw new IllegalArgumentException("Unable to execute ExecuteScriptCommand - mandatory parameter not supplied: person");
        }
        NodeService nodeService = serviceRegistry.getNodeService();
        NodeRef docRef = (NodeRef)properties.get(PROP_DOCUMENT);
        NodeRef spaceRef = null;
        if (docRef != null) {
            spaceRef = nodeService.getPrimaryParent(docRef).getParentRef();
        }
        Map model = serviceRegistry.getScriptService().buildDefaultModel(personRef, new NodeRef(Repository.getStoreRef(), Application.getCompanyRootId()), (NodeRef)nodeService.getProperty(personRef, ContentModel.PROP_HOMEFOLDER), scriptRef, docRef, spaceRef);
        model.put(PROP_ARGS, properties.get(PROP_ARGS));
        return serviceRegistry.getScriptService().executeScript(scriptRef, null, model);
    }
}

