/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.command;

import java.util.Map;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.app.servlet.command.BaseUIActionCommand;
import org.alfresco.web.bean.workflow.WorkflowBean;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageTaskDialogCommand
extends BaseUIActionCommand {
    public static final String PROP_TASKID = "id";
    public static final String PROP_TASKTYPE = "type";
    private static final String[] PROPERTIES = new String[]{"ServletContext", "Request", "Response", "id", "type"};

    @Override
    public Object execute(ServiceRegistry serviceRegistry, Map<String, Object> properties) {
        ServletContext sc = (ServletContext)properties.get("ServletContext");
        ServletRequest req = (ServletRequest)properties.get("Request");
        ServletResponse res = (ServletResponse)properties.get("Response");
        FacesContext fc = FacesHelper.getFacesContext(req, res, sc, "/jsp/close.jsp");
        WorkflowBean wfBean = (WorkflowBean)FacesHelper.getManagedBean(fc, "WorkflowBean");
        String taskId = (String)properties.get(PROP_TASKID);
        ParameterCheck.mandatoryString((String)PROP_TASKID, (String)taskId);
        String taskType = (String)properties.get(PROP_TASKTYPE);
        ParameterCheck.mandatoryString((String)PROP_TASKTYPE, (String)taskType);
        wfBean.setupTaskDialog(taskId, taskType);
        NavigationHandler navigationHandler = fc.getApplication().getNavigationHandler();
        navigationHandler.handleNavigation(fc, null, "dialog:manageTask");
        String viewId = fc.getViewRoot().getViewId();
        try {
            sc.getRequestDispatcher("/faces" + viewId).forward(req, res);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Unable to forward to viewId: " + viewId, (Throwable)e);
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        return PROPERTIES;
    }
}

