/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.actions.BaseActionWizard;
import org.alfresco.web.bean.actions.IHandler;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunActionWizard
extends BaseActionWizard {
    private static final long serialVersionUID = 975435581009378899L;
    protected boolean checkinActionPresent = false;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.checkinActionPresent = false;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        for (Map actionParams : this.allActionsProperties) {
            String actionName;
            this.action = actionName = (String)actionParams.get("actionName");
            if (actionName.equals("check-in")) {
                this.checkinActionPresent = true;
            }
            HashMap<String, Serializable> repoActionParams = new HashMap<String, Serializable>();
            IHandler handler = (IHandler)this.actionHandlers.get(this.action);
            if (handler != null) {
                handler.prepareForSave(actionParams, repoActionParams);
            }
            Action action = this.getActionService().createAction(actionName);
            action.setParameterValues(repoActionParams);
            NodeRef nodeRef = new NodeRef(Repository.getStoreRef(), (String)this.parameters.get("id"));
            this.getActionService().executeAction(action, nodeRef);
        }
        return outcome;
    }

    @Override
    public List<SelectItem> getActions() {
        if (this.actions == null) {
            NodeRef nodeRef = new NodeRef(Repository.getStoreRef(), (String)this.parameters.get("id"));
            List ruleActions = this.getActionService().getActionDefinitions(nodeRef);
            this.actions = new ArrayList();
            for (ActionDefinition ruleActionDef : ruleActions) {
                String title = ruleActionDef.getTitle();
                if (title == null || title.length() == 0) {
                    title = ruleActionDef.getName();
                }
                this.actions.add(new SelectItem((Object)ruleActionDef.getName(), title));
            }
            QuickSort sorter = new QuickSort(this.actions, "label", true, "case-insensitive");
            sorter.sort();
            this.actions.add(0, new SelectItem((Object)"null", Application.getMessage(FacesContext.getCurrentInstance(), "select_an_action")));
        }
        return this.actions;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        Node space;
        Node document = this.browseBean.getDocument();
        if (document != null) {
            document.reset();
        }
        if ((space = this.browseBean.getActionSpace()) != null) {
            space.reset();
        }
        if (this.checkinActionPresent) {
            outcome = "browse";
        }
        return outcome;
    }

    @Override
    protected String getErrorMessageId() {
        return "error_actions";
    }

    public String getSummary() {
        StringBuilder actionsSummary = new StringBuilder();
        for (Map props : this.allActionsProperties) {
            actionsSummary.append(Utils.encode((String)((Serializable)props.get("actionSummary")).toString()));
            actionsSummary.append("<br>");
        }
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        return this.buildSummary(new String[]{bundle.getString("actions")}, new String[]{actionsSummary.toString()});
    }

    @Override
    public boolean getNextButtonDisabled() {
        return this.allActionsDataModel.getRowCount() == 0;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return this.allActionsDataModel.getRowCount() == 0;
    }
}

