/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ajax;

import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.TempFileProvider;
import org.alfresco.web.app.servlet.ajax.InvokeCommand;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.forms.XMLUtil;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ContentUpdateBean
implements Serializable {
    private static final long serialVersionUID = -7209326198823950952L;
    private static Log logger = LogFactory.getLog(ContentUpdateBean.class);

    @InvokeCommand.ResponseMimetype(value="text/html")
    public void updateFile() throws Exception {
        FacesContext fc = FacesContext.getCurrentInstance();
        ExternalContext externalContext = fc.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setHeaderEncoding("UTF-8");
        List fileItems = upload.parseRequest(request);
        String strNodeRef = null;
        String strFilename = null;
        String strReturnPage = null;
        File file = null;
        for (FileItem item : fileItems) {
            if (item.isFormField() && item.getFieldName().equals("return-page")) {
                strReturnPage = item.getString();
                continue;
            }
            if (item.isFormField() && item.getFieldName().equals("nodeRef")) {
                strNodeRef = item.getString();
                continue;
            }
            strFilename = FilenameUtils.getName((String)item.getName());
            file = TempFileProvider.createTempFile((String)"alfresco", (String)".upload");
            item.write(file);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ajax content update request: " + strFilename + " to nodeRef: " + strNodeRef + " return page: " + strReturnPage));
        }
        try {
            NodeRef nodeRef;
            if (file != null && strNodeRef != null && strNodeRef.length() != 0 && (nodeRef = new NodeRef(strNodeRef)) != null) {
                ServiceRegistry services = Repository.getServiceRegistry(fc);
                ContentWriter writer = services.getContentService().getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.putContent(file);
            }
        }
        catch (Exception e) {
            strReturnPage = strReturnPage.replace("${UPLOAD_ERROR}", e.getMessage());
        }
        Document result = XMLUtil.newDocument();
        Element htmlEl = result.createElement("html");
        result.appendChild(htmlEl);
        Element bodyEl = result.createElement("body");
        htmlEl.appendChild(bodyEl);
        Element scriptEl = result.createElement("script");
        bodyEl.appendChild(scriptEl);
        scriptEl.setAttribute("type", "text/javascript");
        Text scriptText = result.createTextNode(strReturnPage);
        scriptEl.appendChild(scriptText);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Content update request complete.");
        }
        ResponseWriter out = fc.getResponseWriter();
        XMLUtil.print((Node)result, (Writer)out);
    }
}

