/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ajax;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.servlet.ajax.InvokeCommand;
import org.alfresco.web.bean.ajax.FileUploadBean;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MySpacesBean
implements Serializable {
    private static final long serialVersionUID = -5684182834188359483L;
    private static Log logger = LogFactory.getLog(MySpacesBean.class);

    @InvokeCommand.ResponseMimetype(value="text/html")
    public void createSpace() throws Exception {
        FacesContext fc = FacesContext.getCurrentInstance();
        ResponseWriter out = fc.getResponseWriter();
        Map requestMap = fc.getExternalContext().getRequestParameterMap();
        String path = (String)requestMap.get("path");
        String name = (String)requestMap.get("name");
        String title = (String)requestMap.get("title");
        String description = (String)requestMap.get("description");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MySpacesBean.createSpace() path=" + path + " name=" + name + " title=" + title + " description=" + description));
        }
        try {
            NodeRef containerRef;
            if (path != null && name != null && (containerRef = FileUploadBean.pathToNodeRef(fc, path)) != null) {
                NodeService nodeService = Repository.getServiceRegistry(fc).getNodeService();
                FileFolderService ffService = Repository.getServiceRegistry(fc).getFileFolderService();
                FileInfo folderInfo = ffService.create(containerRef, name, ContentModel.TYPE_FOLDER);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created new folder: " + folderInfo.getNodeRef().toString()));
                }
                HashMap<QName, String> uiFacetsProps = new HashMap<QName, String>(4, 1.0f);
                uiFacetsProps.put(ApplicationModel.PROP_ICON, "space-icon-default");
                uiFacetsProps.put(ContentModel.PROP_TITLE, title);
                uiFacetsProps.put(ContentModel.PROP_DESCRIPTION, description);
                nodeService.addAspect(folderInfo.getNodeRef(), ApplicationModel.ASPECT_UIFACETS, uiFacetsProps);
                out.write("OK: " + folderInfo.getNodeRef().toString());
            }
        }
        catch (FileExistsException ferr) {
            out.write("ERROR: A file with that name already exists.");
        }
        catch (Throwable err) {
            out.write("ERROR: " + err.getMessage());
        }
    }
}

