/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ajax;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.transaction.UserTransaction;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.UITree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorPluginBean
implements IContextListener,
Serializable {
    private static final long serialVersionUID = 5837326721916936115L;
    public static final String BEAN_NAME = "NavigatorPluginBean";
    protected List<UITree.TreeNode> companyHomeRootNodes;
    protected List<UITree.TreeNode> myHomeRootNodes;
    protected List<UITree.TreeNode> guestHomeRootNodes;
    protected Map<String, UITree.TreeNode> companyHomeNodes;
    protected Map<String, UITree.TreeNode> myHomeNodes;
    protected Map<String, UITree.TreeNode> guestHomeNodes;
    protected NodeRef previouslySelectedNode;
    private transient NodeService nodeService;
    private transient NodeService internalNodeService;
    private transient DictionaryService dictionaryService;
    private static final Log logger = LogFactory.getLog(NavigatorPluginBean.class);

    public NavigatorPluginBean() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).registerBean(this);
    }

    public void retrieveChildren() throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        ResponseWriter out = context.getResponseWriter();
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            Map params = context.getExternalContext().getRequestParameterMap();
            String nodeRefStr = (String)params.get("nodeRef");
            String area = (String)params.get("area");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("retrieveChildren: area = " + area + ", nodeRef = " + nodeRefStr));
            }
            Map<String, UITree.TreeNode> currentNodes = this.getNodesMapForArea(area);
            if (nodeRefStr != null && currentNodes != null) {
                NodeRef parentNodeRef = new NodeRef(nodeRefStr);
                UITree.TreeNode parentNode = currentNodes.get(parentNodeRef.toString());
                parentNode.setExpanded(true);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("retrieving children for noderef: " + parentNodeRef));
                }
                parentNode.removeChildren();
                List childRefs = this.getNodeService().getChildAssocs(parentNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                ArrayList<UITree.TreeNode> sortedNodes = new ArrayList<UITree.TreeNode>();
                for (ChildAssociationRef ref : childRefs) {
                    NodeRef nodeRef = ref.getChildRef();
                    if (!this.isAddableChild(nodeRef)) continue;
                    UITree.TreeNode childNode = this.createTreeNode(nodeRef);
                    parentNode.addChild(childNode);
                    currentNodes.put(childNode.getNodeRef(), childNode);
                    sortedNodes.add(childNode);
                }
                if (sortedNodes.size() > 1) {
                    QuickSort sorter = new QuickSort(sortedNodes, "name", true, "case-insensitive");
                    sorter.sort();
                }
                StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><nodes>");
                for (UITree.TreeNode childNode : sortedNodes) {
                    xml.append(childNode.toXML());
                }
                xml.append("</nodes>");
                out.write(xml.toString());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("returning XML: " + xml.toString()));
                }
            }
            tx.commit();
        }
        catch (Throwable err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    public void nodeCollapsed() throws IOException {
        UITree.TreeNode treeNode;
        FacesContext context = FacesContext.getCurrentInstance();
        ResponseWriter out = context.getResponseWriter();
        Map params = context.getExternalContext().getRequestParameterMap();
        String nodeRefStr = (String)params.get("nodeRef");
        String area = (String)params.get("area");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("nodeCollapsed: area = " + area + ", nodeRef = " + nodeRefStr));
        }
        Map<String, UITree.TreeNode> currentNodes = this.getNodesMapForArea(area);
        if (nodeRefStr != null && currentNodes != null && (treeNode = currentNodes.get(nodeRefStr)) != null) {
            treeNode.setExpanded(false);
            out.write("<ok/>");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set node " + treeNode + " to collapsed state"));
            }
        }
    }

    @Override
    public void contextUpdated() {
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void spaceChanged() {
    }

    public List<UITree.TreeNode> getCompanyHomeRootNodes() {
        if (this.companyHomeRootNodes == null) {
            this.companyHomeRootNodes = new ArrayList<UITree.TreeNode>();
            this.companyHomeNodes = new HashMap<String, UITree.TreeNode>();
            UserTransaction tx = null;
            try {
                FacesContext fc = FacesContext.getCurrentInstance();
                tx = Repository.getUserTransaction(fc, true);
                tx.begin();
                NodeRef root = new NodeRef(Repository.getStoreRef(), Application.getCompanyRootId(fc));
                List childRefs = this.getNodeService().getChildAssocs(root, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                for (ChildAssociationRef ref : childRefs) {
                    NodeRef child = ref.getChildRef();
                    if (!this.isAddableChild(child)) continue;
                    UITree.TreeNode node = this.createTreeNode(child);
                    this.companyHomeRootNodes.add(node);
                    this.companyHomeNodes.put(node.getNodeRef(), node);
                }
                tx.commit();
            }
            catch (Throwable err) {
                Utils.addErrorMessage("NavigatorPluginBean exception in getCompanyHomeRootNodes()", err);
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.companyHomeRootNodes;
    }

    public List<UITree.TreeNode> getMyHomeRootNodes() {
        if (this.myHomeRootNodes == null) {
            this.myHomeRootNodes = new ArrayList<UITree.TreeNode>();
            this.myHomeNodes = new HashMap<String, UITree.TreeNode>();
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
                tx.begin();
                NodeRef root = new NodeRef(Repository.getStoreRef(), Application.getCurrentUser(FacesContext.getCurrentInstance()).getHomeSpaceId());
                List childRefs = this.getNodeService().getChildAssocs(root, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                for (ChildAssociationRef ref : childRefs) {
                    NodeRef child = ref.getChildRef();
                    if (!this.isAddableChild(child)) continue;
                    UITree.TreeNode node = this.createTreeNode(child);
                    this.myHomeRootNodes.add(node);
                    this.myHomeNodes.put(node.getNodeRef(), node);
                }
                tx.commit();
            }
            catch (Throwable err) {
                Utils.addErrorMessage("NavigatorPluginBean exception in getMyHomeRootNodes()", err);
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.myHomeRootNodes;
    }

    public List<UITree.TreeNode> getGuestHomeRootNodes() {
        if (this.guestHomeRootNodes == null) {
            this.guestHomeRootNodes = new ArrayList<UITree.TreeNode>();
            this.guestHomeNodes = new HashMap<String, UITree.TreeNode>();
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
                tx.begin();
                NavigationBean navBean = this.getNavigationBean();
                if (navBean != null) {
                    NodeRef root = navBean.getGuestHomeNode().getNodeRef();
                    List childRefs = this.getNodeService().getChildAssocs(root, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                    for (ChildAssociationRef ref : childRefs) {
                        NodeRef child = ref.getChildRef();
                        if (!this.isAddableChild(child)) continue;
                        UITree.TreeNode node = this.createTreeNode(child);
                        this.guestHomeRootNodes.add(node);
                        this.guestHomeNodes.put(node.getNodeRef(), node);
                    }
                }
                tx.commit();
            }
            catch (Throwable err) {
                Utils.addErrorMessage("NavigatorPluginBean exception in getGuestHomeRootNodes()", err);
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.guestHomeRootNodes;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    private NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setInternalNodeService(NodeService internalNodeService) {
        this.internalNodeService = internalNodeService;
    }

    private NodeService getInternalNodeService() {
        if (this.internalNodeService == null) {
            this.internalNodeService = (NodeService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "nodeService");
        }
        return this.internalNodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    private DictionaryService getDictionaryService() {
        if (this.dictionaryService == null) {
            this.dictionaryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDictionaryService();
        }
        return this.dictionaryService;
    }

    public void selectNode(NodeRef selectedNode, String area) {
        UITree.TreeNode node;
        if (this.previouslySelectedNode != null) {
            if ("companyhome".equals(area) && this.companyHomeNodes != null) {
                node = this.companyHomeNodes.get(this.previouslySelectedNode.toString());
                if (node != null) {
                    node.setSelected(false);
                }
            } else if ("userhome".equals(area) && this.myHomeNodes != null) {
                node = this.myHomeNodes.get(this.previouslySelectedNode.toString());
                if (node != null) {
                    node.setSelected(false);
                }
            } else if ("guesthome".equals(area) && this.guestHomeNodes != null && (node = this.guestHomeNodes.get(this.previouslySelectedNode.toString())) != null) {
                node.setSelected(false);
            }
        }
        if (selectedNode != null) {
            if ("companyhome".equals(area) && this.companyHomeNodes != null) {
                node = this.companyHomeNodes.get(selectedNode.toString());
                if (node != null) {
                    node.setSelected(true);
                }
            } else if ("userhome".equals(area) && this.myHomeNodes != null) {
                node = this.myHomeNodes.get(selectedNode.toString());
                if (node != null) {
                    node.setSelected(true);
                }
            } else if ("guesthome".equals(area) && this.guestHomeNodes != null && (node = this.guestHomeNodes.get(selectedNode.toString())) != null) {
                node.setSelected(true);
            }
        }
        this.previouslySelectedNode = selectedNode;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Selected node: " + selectedNode));
        }
    }

    public void resetSelectedNode() {
        if (this.previouslySelectedNode != null) {
            UITree.TreeNode node;
            if (this.companyHomeNodes != null && (node = this.companyHomeNodes.get(this.previouslySelectedNode.toString())) != null) {
                node.setSelected(false);
            }
            if (this.myHomeNodes != null && (node = this.myHomeNodes.get(this.previouslySelectedNode.toString())) != null) {
                node.setSelected(false);
            }
            if (this.guestHomeNodes != null && (node = this.guestHomeNodes.get(this.previouslySelectedNode.toString())) != null) {
                node.setSelected(false);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reset selected node: " + this.previouslySelectedNode));
            }
        }
    }

    public void reset() {
        this.companyHomeNodes = null;
        this.companyHomeRootNodes = null;
        this.myHomeNodes = null;
        this.myHomeRootNodes = null;
        this.guestHomeNodes = null;
        this.guestHomeRootNodes = null;
        this.resetSelectedNode();
    }

    protected boolean isAddableChild(NodeRef nodeRef) {
        boolean addable = false;
        if (this.getNodeService().exists(nodeRef)) {
            QName type = this.getNodeService().getType(nodeRef);
            TypeDefinition typeDef = this.getDictionaryService().getType(type);
            if (typeDef != null && this.getDictionaryService().isSubClass(type, ContentModel.TYPE_FOLDER) && !this.getDictionaryService().isSubClass(type, ContentModel.TYPE_SYSTEM_FOLDER)) {
                addable = true;
            }
        }
        return addable;
    }

    protected UITree.TreeNode createTreeNode(NodeRef nodeRef) {
        UITree.TreeNode node = new UITree.TreeNode(nodeRef.toString(), Repository.getNameForNode(this.getInternalNodeService(), nodeRef), (String)((Object)this.getInternalNodeService().getProperty(nodeRef, ApplicationModel.PROP_ICON)));
        return node;
    }

    protected NavigationBean getNavigationBean() {
        return (NavigationBean)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "NavigationBean");
    }

    protected BrowseBean getBrowseBean() {
        return (BrowseBean)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "BrowseBean");
    }

    protected Map<String, UITree.TreeNode> getNodesMapForArea(String area) {
        Map<String, UITree.TreeNode> nodes = null;
        if ("companyhome".equals(area)) {
            nodes = this.companyHomeNodes;
        } else if ("userhome".equals(area)) {
            nodes = this.myHomeNodes;
        } else if ("guesthome".equals(area)) {
            nodes = this.guestHomeNodes;
        }
        return nodes;
    }
}

