/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.dashboard;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.bean.dashboard.Column;
import org.alfresco.web.bean.dashboard.DashboardManager;
import org.alfresco.web.bean.dashboard.Page;
import org.alfresco.web.config.DashboardsConfigElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class PageConfig
implements Serializable {
    private static final long serialVersionUID = 5464324390924278215L;
    private static Log logger = LogFactory.getLog(DashboardManager.class);
    private static final String ELEMENT_DASHBOARD = "dashboard";
    private static final String ELEMENT_PAGE = "page";
    private static final String ELEMENT_COLUMN = "column";
    private static final String ELEMENT_DASHLET = "dashlet";
    private static final String ATTR_ID = "id";
    private static final String ATTR_LAYOUTID = "layout-id";
    private static final String ATTR_REFID = "idref";
    private List<Page> pages = new ArrayList<Page>(4);
    private Page currentPage = null;

    public PageConfig() {
    }

    public PageConfig(PageConfig copy) {
        this.pages = new ArrayList<Page>(copy.pages.size());
        for (Page page : copy.pages) {
            this.pages.add(new Page(page));
        }
    }

    public Page getCurrentPage() {
        if (this.currentPage == null && this.pages.size() != 0) {
            this.currentPage = this.pages.get(0);
        }
        return this.currentPage;
    }

    public void setCurrentPage(String pageId) {
        for (Page page : this.pages) {
            if (!page.getId().equals(pageId)) continue;
            this.currentPage = page;
            break;
        }
    }

    public void addPage(Page page) {
        this.pages.add(page);
    }

    public Page getPage(String pageId) {
        Page foundPage = null;
        for (Page page : this.pages) {
            if (!page.getId().equals(pageId)) continue;
            foundPage = page;
            break;
        }
        return foundPage;
    }

    public String toXML() {
        try {
            Document doc = DocumentHelper.createDocument();
            Element root = doc.addElement(ELEMENT_DASHBOARD);
            for (Page page : this.pages) {
                Element pageElement = root.addElement(ELEMENT_PAGE);
                pageElement.addAttribute(ATTR_ID, page.getId());
                pageElement.addAttribute(ATTR_LAYOUTID, page.getLayoutDefinition().Id);
                for (Column column : page.getColumns()) {
                    Element columnElement = pageElement.addElement(ELEMENT_COLUMN);
                    for (DashboardsConfigElement.DashletDefinition dashletDef : column.getDashlets()) {
                        columnElement.addElement(ELEMENT_DASHLET).addAttribute(ATTR_REFID, dashletDef.Id);
                    }
                }
            }
            StringWriter out = new StringWriter(512);
            XMLWriter writer = new XMLWriter(OutputFormat.createPrettyPrint());
            writer.setWriter((Writer)out);
            writer.write(doc);
            return out.toString();
        }
        catch (Throwable err) {
            throw new AlfrescoRuntimeException("Unable to serialize Dashboard PageConfig to XML: " + err.getMessage(), err);
        }
    }

    public String toString() {
        return this.toXML();
    }

    public void fromXML(DashboardsConfigElement config, String xml) {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read((Reader)new StringReader(xml));
            Element rootElement = document.getRootElement();
            Iterator itrPages = rootElement.elementIterator(ELEMENT_PAGE);
            while (itrPages.hasNext()) {
                Element pageElement = (Element)itrPages.next();
                String layoutId = pageElement.attributeValue(ATTR_LAYOUTID);
                DashboardsConfigElement.LayoutDefinition layoutDef = config.getLayoutDefinition(layoutId);
                if (layoutDef != null) {
                    Page page = new Page(pageElement.attributeValue(ATTR_ID), layoutDef);
                    Iterator itrColumns = pageElement.elementIterator(ELEMENT_COLUMN);
                    while (itrColumns.hasNext()) {
                        Column column = new Column();
                        Element columnElement = (Element)itrColumns.next();
                        Iterator itrDashlets = columnElement.elementIterator(ELEMENT_DASHLET);
                        while (itrDashlets.hasNext()) {
                            String dashletId = ((Element)itrDashlets.next()).attributeValue(ATTR_REFID);
                            DashboardsConfigElement.DashletDefinition dashletDef = config.getDashletDefinition(dashletId);
                            if (dashletDef != null) {
                                column.addDashlet(dashletDef);
                                continue;
                            }
                            if (!logger.isWarnEnabled()) continue;
                            logger.warn((Object)("Failed to resolve Dashboard Dashlet Definition ID: " + dashletId));
                        }
                        page.addColumn(column);
                    }
                    this.addPage(page);
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn((Object)("Failed to resolve Dashboard Layout Definition ID: " + layoutId));
            }
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }
}

