/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.forums;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ForumModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.spaces.DeleteSpaceDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteForumDialog
extends DeleteSpaceDialog {
    private static final long serialVersionUID = -4246549059188399460L;
    protected boolean reDisplayForums;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.reDisplayForums = false;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        QName type;
        Node node = this.browseBean.getActionSpace();
        NodeRef parent = null;
        ChildAssociationRef assoc = this.getNodeService().getPrimaryParent(node.getNodeRef());
        if (assoc != null) {
            parent = assoc.getParentRef();
            QName parentType = this.getNodeService().getType(parent);
            if (parentType.equals((Object)ForumModel.TYPE_FORUMS)) {
                this.reDisplayForums = true;
            }
        }
        outcome = super.finishImpl(context, outcome);
        if (assoc != null && parent != null && (type = assoc.getTypeQName()).equals((Object)ForumModel.ASSOC_DISCUSSION)) {
            this.getNodeService().removeAspect(parent, ForumModel.ASPECT_DISCUSSABLE);
        }
        return outcome;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        outcome = super.doPostCommitProcessing(context, outcome);
        if (this.reDisplayForums) {
            return "dialog:close:forumDeleted";
        }
        return outcome;
    }

    @Override
    protected String getConfirmMessageId() {
        return "delete_forum_confirm";
    }
}

