/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ml;

import java.io.Serializable;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditMLContainerDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -6340255019962646300L;
    private transient MultilingualContentService multilingualContentService;
    private Node editableNode;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.editableNode = this.initEditableNode();
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "ok");
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        NodeRef container = this.editableNode.getNodeRef();
        Map<String, Object> editProperties = this.editableNode.getProperties();
        for (Map.Entry<String, Object> entry : editProperties.entrySet()) {
            QName qname = QName.createQName((String)entry.getKey());
            if (qname.getNamespaceURI().equals("http://www.alfresco.org/model/system/1.0")) continue;
            this.getNodeService().setProperty(container, qname, (Serializable)entry.getValue());
        }
        return outcome;
    }

    protected Node initEditableNode() {
        Node currentNode = this.browseBean.getDocument();
        if (ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)currentNode.getType())) {
            return currentNode;
        }
        return new Node(this.getMultilingualContentService().getTranslationContainer(currentNode.getNodeRef()));
    }

    public Node getEditableNode() {
        return this.editableNode;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        this.browseBean.getDocument().reset();
        return outcome;
    }

    public MultilingualContentService getMultilingualContentService() {
        if (this.multilingualContentService == null) {
            this.multilingualContentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMultilingualContentService();
        }
        return this.multilingualContentService;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }
}

