/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ml;

import java.io.Serializable;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Node;

public class MultilingualUtils
implements Serializable {
    private static final long serialVersionUID = 2218309432064312000L;

    public static boolean canAddChildrenToPivotSpace(Node multlingualDocument, FacesContext fc) {
        MultilingualContentService mlservice = MultilingualUtils.getMultilingualContentService(fc);
        NodeService nodeService = MultilingualUtils.getNodeService(fc);
        NodeRef pivot = mlservice.getPivotTranslation(multlingualDocument.getNodeRef());
        NodeRef space = nodeService.getPrimaryParent(pivot).getParentRef();
        return new Node(space).hasPermission("AddChildren");
    }

    public static boolean canDeleteEachTranslation(Node multlingualDocument, FacesContext fc) {
        boolean can = true;
        MultilingualContentService mlservice = MultilingualUtils.getMultilingualContentService(fc);
        Map translations = mlservice.getTranslations(multlingualDocument.getNodeRef());
        for (Map.Entry entry : translations.entrySet()) {
            Node translation = new Node((NodeRef)entry.getValue());
            if (translation.hasPermission("DeleteNode") && !translation.isLocked() && !translation.hasAspect(ContentModel.ASPECT_WORKING_COPY)) continue;
            can = false;
            break;
        }
        return can;
    }

    public static boolean canMoveEachTranslation(Node multlingualDocument, FacesContext fc) {
        boolean can = true;
        MultilingualContentService mlservice = MultilingualUtils.getMultilingualContentService(fc);
        Map translations = mlservice.getTranslations(multlingualDocument.getNodeRef());
        for (Map.Entry entry : translations.entrySet()) {
            Node translation = new Node((NodeRef)entry.getValue());
            if (translation.hasPermission("DeleteNode")) continue;
            can = false;
            break;
        }
        return can;
    }

    public static boolean canStartNewEditon(Node multlingualDocument, FacesContext fc) {
        boolean canDelete = MultilingualUtils.canMoveEachTranslation(multlingualDocument, fc);
        boolean canCreate = MultilingualUtils.canAddChildrenToPivotSpace(multlingualDocument, fc);
        return canDelete && canCreate;
    }

    private static MultilingualContentService getMultilingualContentService(FacesContext fc) {
        return (MultilingualContentService)FacesHelper.getManagedBean(fc, "MultilingualContentService");
    }

    private static NodeService getNodeService(FacesContext fc) {
        return (NodeService)FacesHelper.getManagedBean(fc, "NodeService");
    }
}

