/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.repository;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.namespace.NamespacePrefixResolverProvider;
import org.alfresco.service.namespace.QNameMap;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.NodePropertyResolver;
import org.alfresco.web.bean.repository.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QNameNodeMap<K, V>
extends QNameMap
implements Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1760755862411509263L;
    private Node parent = null;
    private Map<String, NodePropertyResolver> resolvers = new HashMap<String, NodePropertyResolver>(8, 1.0f);

    public QNameNodeMap(NamespacePrefixResolverProvider provider, Node parent) {
        super(provider);
        if (parent == null) {
            throw new IllegalArgumentException("Parent Node cannot be null!");
        }
        this.parent = parent;
    }

    protected QNameNodeMap() {
    }

    public void addPropertyResolver(String name, NodePropertyResolver resolver) {
        this.resolvers.put(name, resolver);
    }

    public boolean containsPropertyResolver(String name) {
        return this.resolvers.containsKey(name);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.contents.containsKey(Repository.resolveToQNameString((String)key)) || this.resolvers.containsKey(key);
    }

    public Object get(Object key) {
        NodePropertyResolver resolver;
        String qnameKey = Repository.resolveToQNameString(key.toString());
        Object obj = this.contents.get(qnameKey);
        if (obj == null && (resolver = this.resolvers.get(key.toString())) != null) {
            obj = resolver.get(this.parent);
            this.contents.put(qnameKey, obj);
        }
        return obj;
    }

    public Object getRaw(Object key) {
        return this.contents.get(Repository.resolveToQNameString((String)key));
    }

    public Object clone() {
        QNameNodeMap<K, V> map = new QNameNodeMap<K, V>(this.provider, this.parent);
        map.putAll(this);
        if (this.resolvers.size() != 0) {
            map.resolvers = (Map)((HashMap)this.resolvers).clone();
        }
        return map;
    }
}

